/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.resource.core.ResourceIndexer;
import com.af.v4.system.common.resource.mapper.LogicMapper;
import com.af.v4.system.runtime.annotation.OpenApi;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/logic"})
public class LogicController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicController.class);
    private static final String RESPONSE_HEADER = "header";
    private static final String RESPONSE_CONTENT = "content";
    private static final String RESPONSE_VALUE = "value";
    private final LogicService logicService;
    private final LogicMapper logicMapper;

    public LogicController(LogicService logicService, LogicMapper logicMapper) {
        this.logicService = logicService;
        this.logicMapper = logicMapper;
    }

    @Log(title="\u8c03\u7528Logic", businessType=BusinessType.LOGIC)
    @RequestMapping(value={"{logicName}"}, produces={"application/json"})
    public Object run(@PathVariable(value="logicName") String logicName, @RequestBody(required=false) String values, HttpServletResponse response, HttpServletRequest request) {
        String params = this.getRequestParams(values, request);
        return this.runMain(logicName, params, response);
    }

    @Log(title="\u5f02\u6b65\u8c03\u7528Logic", businessType=BusinessType.LOGIC)
    @RequestMapping(value={"/async/{logicName}"}, produces={"application/json"})
    public Object runAsync(@PathVariable(value="logicName") String logicName, @RequestBody(required=false) String values, HttpServletRequest request) {
        String params = this.getRequestParams(values, request);
        this.logicService.runAsync(logicName, params).whenComplete((o, e) -> {
            if (o != null) {
                LOGGER.info("\u5f02\u6b65\u8c03\u7528\u7ed3\u679c\uff1a{}", o);
            }
        });
        return R.ok((Object)"ok");
    }

    @Log(title="\u65e0token\u8c03\u7528Logic", businessType=BusinessType.LOGIC)
    @RequestMapping(value={"/openapi/{logicName}"}, produces={"application/json"})
    @OpenApi
    public Object runByNoToken(@PathVariable(value="logicName") String logicName, @RequestBody(required=false) String values, HttpServletResponse response, HttpServletRequest request) {
        return this.run(logicName, values, response, request);
    }

    @Log(title="\u65e0token\u5f02\u6b65\u8c03\u7528Logic", businessType=BusinessType.LOGIC)
    @RequestMapping(value={"/openapi/async/{logicName}"}, produces={"application/json"})
    @OpenApi
    public Object runAsyncByNoToken(@PathVariable(value="logicName") String logicName, @RequestBody(required=false) String values, HttpServletRequest request) {
        return this.runAsync(logicName, values, request);
    }

    @Log(title="\u6e05\u7406\u6240\u6709\u7f13\u5b58", businessType=BusinessType.CLEAR_CACHE)
    @GetMapping(value={"/clearAll"}, produces={"application/json"})
    public R<String> clearAllCache() {
        ResourceIndexer.clearLogicCache();
        ResourceIndexer.clearSqlCache();
        return R.ok((Object)"ok");
    }

    private String getValues(String values, HttpServletRequest request) {
        if (!values.startsWith("{")) {
            JSONObject paramJson = new JSONObject();
            paramJson.put("str", (Object)values);
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                JSONObject header = new JSONObject();
                while (headerNames.hasMoreElements()) {
                    String temp = (String)headerNames.nextElement();
                    header.put(temp, (Object)request.getHeader(temp));
                }
                paramJson.put(RESPONSE_HEADER, (Object)header);
            }
            values = paramJson.toString();
        }
        return values;
    }

    private String getRequestParams(String values, HttpServletRequest request) {
        String params;
        if (request.getMethod().equals(HttpMethod.GET.name()) && Optional.ofNullable(values).isEmpty()) {
            Map parameterMap = request.getParameterMap();
            JSONObject parameterMapObj = new JSONObject(parameterMap);
            params = parameterMapObj.toString();
        } else {
            params = this.getValues(values, request);
        }
        return params;
    }

    private Object runMain(String logicName, String values, HttpServletResponse response) {
        Map map;
        HashMap<String, Object> result;
        JSONObject object;
        Object runResult = this.logicService.run(logicName, values);
        if (runResult instanceof JSONObject && (object = (JSONObject)runResult).has(RESPONSE_HEADER) && object.has(RESPONSE_CONTENT)) {
            JSONObject paramHeader = object.getJSONObject(RESPONSE_HEADER);
            for (String key : paramHeader.keySet()) {
                response.setHeader(key, String.valueOf(paramHeader.get(key)));
            }
            runResult = object.get(RESPONSE_CONTENT);
        }
        if (runResult instanceof JSONObject) {
            JSONObject json = (JSONObject)runResult;
            result = json.toMap();
        } else if (runResult instanceof JSONArray) {
            JSONArray array = (JSONArray)runResult;
            result = array.toList();
        } else if (runResult instanceof Map || runResult instanceof Collection) {
            result = runResult;
        } else if (runResult == null) {
            result = null;
        } else {
            HashMap<String, Object> objResult = new HashMap<String, Object>(1);
            objResult.put(RESPONSE_VALUE, runResult);
            result = objResult;
        }
        LogicMapper.LogicResource resource = this.logicMapper.getValue(logicName);
        if (resource.isCallbackApi()) {
            return result;
        }
        if (result instanceof Map && (map = (Map)result).containsKey("status")) {
            int status = (Integer)map.get("status");
            if (status == 200 && map.containsKey("data")) {
                return R.ok(map.get("data"));
            }
            if (status != 200 && map.containsKey("msg")) {
                return R.fail((int)status, (String)((String)map.get("msg")));
            }
        }
        return R.ok((Object)result);
    }
}

