/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.aspect;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.resource.mapper.LogicMapper;
import com.af.v4.system.runtime.annotation.OpenApi;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class OpenApiAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiAspect.class);
    private final LogicService logicService;

    public OpenApiAspect(LogicService logicService) {
        this.logicService = logicService;
    }

    @Before(value="@annotation(openApi)")
    public void boBefore(JoinPoint joinPoint, OpenApi openApi) {
        Object[] params = joinPoint.getArgs();
        String resName = params[0].toString();
        this.checkAuth(resName);
    }

    private void checkAuth(String resName) {
        LogicMapper.LogicResource logicResource = this.logicService.getLogicResource(resName);
        boolean isAuth = logicResource.getAuth();
        if (isAuth) {
            throw new ServiceException("\u975e\u6cd5\u8bbf\u95ee\u63a5\u53e3", Integer.valueOf(401));
        }
    }
}

