package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * SQL控制器（兼容）
 *
 * @author Mr.river
 * @apiNote 该api存在安全隐患，仅用于保持对v3及以前版本的兼容，
 * <p>该api随时都有可能移除，请不要使用该api开发任何新业务，对于以前的旧业务，
 * 也应尽快调整为使用更加安全的LogicController或EntityController</p>
 * @see com.af.v4.system.runtime.controller.LogicController
 * @see com.af.v4.system.runtime.controller.EntityController
 */
@Deprecated(since = "1.0.0", forRemoval = true)
@RestController
@RequestMapping("/sql")
public class SQLController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLController.class);
    private final SqlService sqlService;

    public SQLController(SqlService sqlService) {
        this.sqlService = sqlService;
    }


    @Log(title = "获取合计执行结果", businessType = BusinessType.SQL)
    @PostMapping(value = "{sqlName}/n", produces = MediaType.APPLICATION_JSON_VALUE)
    public Object queryTotal(@PathVariable("sqlName") String sqlName,
                             @RequestBody(required = false) String values) {
        JSONObject runResult = sqlService.queryTotal(sqlName, values);
        return parseResult(runResult);
    }

    @Log(title = "根据SQL文件执行查询", businessType = BusinessType.SQL)
    @PostMapping(value = "{sqlName}", produces = MediaType.APPLICATION_JSON_VALUE)
    public Object query(@PathVariable("sqlName") String sqlName,
                        @RequestParam("pageNo") int pageNo,
                        @RequestParam("pageSize") int pageSize,
                        @RequestBody(required = false) String values) {
        JSONArray runResult = sqlService.query(sqlName, values == null ? new JSONObject() : new JSONObject(values), pageNo, pageSize);
        return parseResult(runResult);
    }

    private R<Object> parseResult(Object runResult) {
        // 转换执行结果
        Object result = null;
        if (runResult instanceof JSONObject json) {
            result = json.toMap();
        } else if (runResult instanceof JSONArray array) {
            result = array.toList();
        }
        return R.ok(result);
    }
}
