/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.sql.dynamic;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.restful.sql.dynamic.DynamicSessionFactory;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.Query;
import javax.persistence.SynchronizationType;
import javax.persistence.criteria.CriteriaBuilder;
import org.hibernate.Cache;
import org.hibernate.HibernateException;
import org.hibernate.Metamodel;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.StatelessSessionBuilder;
import org.hibernate.TypeHelper;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.Statistics;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;

public class DynamicSessionFactoryImpl
implements DynamicSessionFactory {
    private static final long serialVersionUID = 5384069312247414885L;
    private final Map<Object, LocalSessionFactoryBean> targetLocalSessionFactoryBeans;
    private final LocalSessionFactoryBean defaultLocalSessionFactoryBean;

    public DynamicSessionFactoryImpl(Map<Object, LocalSessionFactoryBean> targetLocalSessionFactoryBeans, LocalSessionFactoryBean defaultLocalSessionFactoryBean) {
        this.targetLocalSessionFactoryBeans = targetLocalSessionFactoryBeans;
        this.defaultLocalSessionFactoryBean = defaultLocalSessionFactoryBean;
    }

    @Override
    public SessionFactory getHibernateSessionFactory() {
        return this.getLocalSessionFactoryBean().getObject();
    }

    @Override
    public Configuration getConfiguration() {
        return this.getLocalSessionFactoryBean().getConfiguration();
    }

    @Override
    public LocalSessionFactoryBean getLocalSessionFactoryBean() {
        LocalSessionFactoryBean localSessionFactoryBean = this.targetLocalSessionFactoryBeans.get(DynamicDataSource.getDataSource());
        if (localSessionFactoryBean != null) {
            return localSessionFactoryBean;
        }
        return this.defaultLocalSessionFactoryBean;
    }

    @Override
    public Metadata getMetadata() {
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)this.getConfiguration().getStandardServiceRegistryBuilder().build());
        return metadataSources.buildMetadata();
    }

    public SessionFactoryOptions getSessionFactoryOptions() {
        return this.getHibernateSessionFactory().getSessionFactoryOptions();
    }

    public SessionBuilder withOptions() {
        return this.getHibernateSessionFactory().withOptions();
    }

    public Session openSession() throws HibernateException {
        return this.getHibernateSessionFactory().openSession();
    }

    public Session getCurrentSession() throws HibernateException {
        return this.getHibernateSessionFactory().getCurrentSession();
    }

    public StatelessSessionBuilder withStatelessOptions() {
        return this.getHibernateSessionFactory().withStatelessOptions();
    }

    public StatelessSession openStatelessSession() {
        return this.getHibernateSessionFactory().openStatelessSession();
    }

    public StatelessSession openStatelessSession(Connection connection) {
        return this.getHibernateSessionFactory().openStatelessSession(connection);
    }

    public Statistics getStatistics() {
        return this.getHibernateSessionFactory().getStatistics();
    }

    public void close() throws HibernateException {
        this.getHibernateSessionFactory().close();
    }

    public Map<String, Object> getProperties() {
        return this.getHibernateSessionFactory().getProperties();
    }

    public boolean isClosed() {
        return this.getHibernateSessionFactory().isClosed();
    }

    public Cache getCache() {
        return this.getHibernateSessionFactory().getCache();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.getHibernateSessionFactory().getPersistenceUnitUtil();
    }

    public void addNamedQuery(String name, Query query) {
        this.getHibernateSessionFactory().addNamedQuery(name, query);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.getHibernateSessionFactory().unwrap(cls);
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.getHibernateSessionFactory().addNamedEntityGraph(graphName, entityGraph);
    }

    public Set getDefinedFilterNames() {
        return this.getHibernateSessionFactory().getDefinedFilterNames();
    }

    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return this.getHibernateSessionFactory().getFilterDefinition(filterName);
    }

    public boolean containsFetchProfileDefinition(String name) {
        return this.getHibernateSessionFactory().containsFetchProfileDefinition(name);
    }

    public TypeHelper getTypeHelper() {
        return this.getHibernateSessionFactory().getTypeHelper();
    }

    public ClassMetadata getClassMetadata(Class entityClass) {
        return this.getHibernateSessionFactory().getClassMetadata(entityClass);
    }

    public ClassMetadata getClassMetadata(String entityName) {
        return this.getHibernateSessionFactory().getClassMetadata(entityName);
    }

    public CollectionMetadata getCollectionMetadata(String roleName) {
        return this.getHibernateSessionFactory().getCollectionMetadata(roleName);
    }

    public Map<String, ClassMetadata> getAllClassMetadata() {
        return this.getHibernateSessionFactory().getAllClassMetadata();
    }

    public Map getAllCollectionMetadata() {
        return this.getHibernateSessionFactory().getAllCollectionMetadata();
    }

    public Reference getReference() throws NamingException {
        return this.getHibernateSessionFactory().getReference();
    }

    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> entityClass) {
        return this.getHibernateSessionFactory().findEntityGraphsByType(entityClass);
    }

    public EntityManager createEntityManager() {
        return this.getHibernateSessionFactory().createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.getHibernateSessionFactory().createEntityManager(map);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return this.getHibernateSessionFactory().createEntityManager(synchronizationType);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        return this.getHibernateSessionFactory().createEntityManager(synchronizationType, map);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getHibernateSessionFactory().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.getHibernateSessionFactory().getMetamodel();
    }

    public boolean isOpen() {
        return this.getHibernateSessionFactory().isOpen();
    }
}

