/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.service;

import com.af.v4.system.api.RemoteEntityService;
import com.af.v4.system.api.RemoteLogicService;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.expression.Expression;
import com.af.v4.system.expression.exception.ExplicitException;
import com.af.v4.system.restful.mapper.AbstractResourceMapper;
import com.af.v4.system.restful.mapper.LogicMapper;
import com.af.v4.system.restful.mapper.PluginMapper;
import com.af.v4.system.restful.mapper.ResourceMapper;
import com.af.v4.system.restful.service.EntityService;
import com.af.v4.system.restful.service.ExceptionLogService;
import com.af.v4.system.restful.service.LogicNewTranService;
import com.af.v4.system.restful.service.SqlService;
import com.af.v4.system.restful.utils.ExceptionHelper;
import com.af.v4.system.restful.utils.enums.ResourceType;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class LogicService {
    private static final Logger LOGGER = LogManager.getLogger(LogicService.class);
    private final SqlService sqlService;
    private final LogicNewTranService logicNewTranService;
    private final ResourceMapper resourceMapper;
    private final RedisService redisService;
    private final RemoteLogicService remoteLogicService;
    private final RemoteEntityService remoteEntityService;
    private final EntityService entityService;
    private final PluginMapper pluginMapper;
    private final LogicMapper logicMapper;

    public LogicService(SqlService sqlService, LogicNewTranService newLogicService, ResourceMapper resourceMapper, RedisService redisService, RemoteLogicService remoteLogicService, RemoteEntityService remoteEntityService, EntityService entityService, PluginMapper pluginMapper, LogicMapper logicMapper) {
        this.sqlService = sqlService;
        this.logicNewTranService = newLogicService;
        this.resourceMapper = resourceMapper;
        this.redisService = redisService;
        this.remoteLogicService = remoteLogicService;
        this.remoteEntityService = remoteEntityService;
        this.entityService = entityService;
        this.pluginMapper = pluginMapper;
        this.logicMapper = logicMapper;
    }

    public Object run(String name, String str) {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                Object dataParam;
                JSONObject st = (JSONObject)json;
                param = st;
                if (!param.isNull("data") && (dataParam = param.get("data")) instanceof JSONObject) {
                    param = (JSONObject)dataParam;
                    param.put("standardData", (Object)new JSONObject(str).toString());
                }
            } else if (json instanceof JSONArray) {
                JSONArray ar = (JSONArray)json;
                param = new JSONObject();
                param.put("arr", (Object)ar);
            }
        }
        return this.run(name, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run(String name, JSONObject param) {
        AbstractResourceMapper.CommonResource commonResource = this.logicMapper.getValue(name);
        String path = (String)commonResource.getPath();
        name = commonResource.getAlias();
        LOGGER.info("\u7ef4\u62a4\u4fe1\u606f:\u5f00\u59cb\u6267\u884cLogic[" + name + "]\uff0c\u53c2\u6570\uff1a" + param);
        if (path == null) {
            throw new ServiceException("\u4e1a\u52a1\u903b\u8f91\u672a\u627e\u5230: " + name);
        }
        String source = this.resourceMapper.getString(ResourceType.LOGIC, name, path);
        Map<String, Object> params = this.pluginMapper.getAllMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, object -> ((Map)object.getValue()).get("value")));
        params.put("data", param);
        params.put("log", LOGGER);
        params.put("entity", this.entityService);
        params.put("remoteEntity", this.remoteEntityService);
        params.put("sql", this.sqlService);
        params.put("redis", this.redisService);
        params.put("logic", this);
        long begin = System.currentTimeMillis();
        try {
            Map res = this.logicMapper.getRes(name);
            String dataSource = (String)res.get("dataSource");
            if (dataSource != null) {
                LOGGER.info("\u7ef4\u62a4\u4fe1\u606f:Logic[" + name + "]\u4f7f\u7528\u6570\u636e\u6e90\uff1a" + dataSource);
                if (!Objects.equals(dataSource, DynamicDataSource.getDataSource())) {
                    DynamicDataSource.setDataSource((String)dataSource);
                }
                Object object2 = this.logicNewTranService.runNewTranExpression(source, params);
                return object2;
            }
            DynamicDataSource.setDataSource(null);
            Object object3 = this.runExpression(source, params);
            return object3;
        }
        finally {
            DynamicDataSource.clearDataSource();
            long end = System.currentTimeMillis();
            long time = end - begin;
            String engMessage = "\u7ef4\u62a4\u4fe1\u606f:\u6267\u884cLogic[" + name + "]\u8017\u65f6:" + time;
            if (time >= 8000L) {
                LOGGER.error(engMessage);
            } else if (time >= 4000L) {
                LOGGER.warn(engMessage);
            } else {
                LOGGER.info(engMessage);
            }
        }
    }

    public Object runExpression(String source, Map<String, Object> params) {
        return Expression.run((String)source, params);
    }

    public Object runMain(String logicName, String values) {
        try {
            Object result = this.run(logicName, values);
            if (result == null) {
                return "";
            }
            return result;
        }
        catch (Exception ex) {
            throw this.buildServiceException(ex);
        }
    }

    private ServiceException buildServiceException(Exception ex) {
        ServiceException serviceException = null;
        if (ex instanceof ServiceException) {
            ServiceException e;
            serviceException = e = (ServiceException)ex;
        } else if (ex instanceof ExplicitException) {
            ExplicitException e = (ExplicitException)ex;
            serviceException = new ServiceException(e.getMessage(), e.getCode());
            serviceException.setDetailMessage(e.getDetailMessage());
        } else {
            Throwable cause = ex.getCause();
            if (cause instanceof InvocationTargetException) {
                InvocationTargetException targetException = (InvocationTargetException)cause;
                Throwable throwable = targetException.getTargetException();
                if (throwable instanceof ServiceException) {
                    ServiceException e;
                    serviceException = e = (ServiceException)throwable;
                } else {
                    throwable = targetException.getTargetException();
                    if (throwable instanceof ExplicitException) {
                        ExplicitException e = (ExplicitException)throwable;
                        serviceException = new ServiceException(e.getMessage(), e.getCode());
                        serviceException.setDetailMessage(e.getDetailMessage());
                    }
                }
            }
        }
        if (serviceException == null) {
            serviceException = new ServiceException();
            serviceException.setMessage("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
        }
        String stack = ExceptionLogService.getErrorInfo(ExceptionHelper.stackToString(ex), ExceptionLogService.BusinessType.LOGIC);
        serviceException.setDetailMessage(stack);
        return serviceException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject remoteRun(String serviceName, String logicName, String params) {
        LOGGER.info("\u7ef4\u62a4\u4fe1\u606f:\u5f00\u59cb\u8fdc\u7a0b\u8c03\u7528" + serviceName + "\u7684Logic[" + logicName + "]\uff0c\u53c2\u6570\uff1a" + params);
        long begin = System.currentTimeMillis();
        try {
            R logicResult = this.remoteLogicService.run(serviceName, logicName, params, "inner");
            JSONObject jSONObject = logicResult.parseResponseJson();
            return jSONObject;
        }
        finally {
            long end = System.currentTimeMillis();
            long time = end - begin;
            String engMessage = "\u7ef4\u62a4\u4fe1\u606f:\u8fdc\u7a0b\u8c03\u7528Logic[" + logicName + "]\u8017\u65f6:" + time;
            if (time >= 8000L) {
                LOGGER.error(engMessage);
            } else if (time >= 4000L) {
                LOGGER.warn(engMessage);
            } else {
                LOGGER.info(engMessage);
            }
        }
    }

    public JSONObject remoteRun(String serviceName, String logicName, JSONObject params) {
        return this.remoteRun(serviceName, logicName, params.toString());
    }
}

