/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.service;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.plugins.calculate.CalculateUtil;
import com.af.v4.system.plugins.core.CommonTools;
import com.af.v4.system.plugins.core.ConvertTools;
import com.af.v4.system.plugins.date.DateTools;
import com.af.v4.system.restful.enums.file.ResUploadModeEnum;
import com.af.v4.system.restful.service.EntityService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class FileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileService.class);
    private final EntityService entityService;
    private static final String STATIC_RES_URL = "/resource";

    public FileService(EntityService entityService) {
        this.entityService = entityService;
    }

    public FileUploadResult uploadFile(MultipartFile file, String resUploadMode, int stockId, String operator, String pathKey, String formType, String useType) {
        JSONArray extraPathKeys;
        ResUploadModeEnum resUploadTypeEnum = ResUploadModeEnum.toType(resUploadMode);
        if (resUploadTypeEnum == null) {
            return new FileUploadResult(false, "\u4e0d\u652f\u6301\u8be5\u8d44\u6e90\u4e0a\u4f20\u7c7b\u578b\uff1a" + resUploadMode);
        }
        JSONObject response = this.entityService.remoteGetById("af-system", "f_root_path, f_alias, f_lower_path_json", "t_files_manager", stockId);
        if (response.getInt("status") != 200) {
            String msg = response.optString("msg", "unknown error");
            return new FileUploadResult(false, "\u67e5\u8be2\u4ed3\u5e93\u4fe1\u606f\u5931\u8d25\uff1a" + msg);
        }
        JSONObject stock = response.getJSONObject("data");
        String rootPath = stock.getString("f_root_path");
        String path = rootPath + stock.getString("f_alias");
        String extraPathKey = null;
        if (pathKey != null && (extraPathKeys = new JSONArray((Collection)new JSONArray(stock.getString("f_lower_path_json")).toList().stream().filter(item -> Objects.equals(((Map)item).get("label"), pathKey)).collect(Collectors.toList()))).length() > 0) {
            extraPathKey = extraPathKeys.getJSONObject(0).getString("value");
        }
        String fileName = file.getOriginalFilename();
        BigDecimal fileSize = CalculateUtil.div((Object)file.getSize(), (Object)0x100000, (Integer)4);
        return switch (resUploadTypeEnum) {
            case ResUploadModeEnum.SERVER -> {
                if (!$assertionsDisabled && fileName == null) {
                    throw new AssertionError();
                }
                Map<String, Object> entity = this.uploadFileToServer(file, stockId, rootPath, path, extraPathKey, fileName, fileSize, operator, formType, useType);
                yield new FileUploadResult(true, entity);
            }
            case ResUploadModeEnum.BASE64 -> {
                Map<String, Object> entity = this.uploadFileToBase64(file);
                yield new FileUploadResult(true, entity);
            }
            case ResUploadModeEnum.OSS -> {
                Map<String, Object> entity = this.uploadFileToOSS(file);
                yield new FileUploadResult(true, entity);
            }
            default -> throw new ServiceException("\u4e0d\u652f\u6301\u7684\u4e0a\u4f20\u6a21\u5f0f\uff1a" + resUploadTypeEnum.getValue());
        };
    }

    public Map<String, Object> uploadFileToServer(MultipartFile file, int f_stock_id, String rootPath, String path, String extraPathKey, String filename, BigDecimal filesize, String operator, String formType, String useType) {
        String fileSuffix = filename.substring(filename.lastIndexOf(46) + 1);
        if (extraPathKey != null) {
            path = (String)path + File.separator + extraPathKey;
        }
        String fileName = CommonTools.getUUID((Boolean)true) + "." + fileSuffix;
        path = (String)path + File.separator + DateTools.getNow((String)"yyyyMMdd") + File.separator + fileName;
        File fileDir = new File((String)path);
        try {
            FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)fileDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JSONObject files_entity = new JSONObject();
        String downloadPath = "/resource/" + ((String)path).replace(File.separator, "/").substring(rootPath.length());
        files_entity.put("f_filename", (Object)filename);
        files_entity.put("f_stock_id", f_stock_id);
        files_entity.put("f_filetype", (Object)fileSuffix);
        files_entity.put("f_downloadpath", (Object)downloadPath);
        files_entity.put("f_realpath", path);
        files_entity.put("f_file_size", (Object)filesize);
        files_entity.put("f_operator", (Object)operator);
        files_entity.put("f_form_type", (Object)formType);
        files_entity.put("f_use_type", (Object)useType);
        try {
            files_entity.put("id", (Object)this.entityService.partialSave("t_files", files_entity).getString("id"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return files_entity.toMap();
    }

    public Map<String, Object> uploadFileToBase64(MultipartFile file) {
        try {
            HashMap<String, Object> message = new HashMap<String, Object>(1);
            message.put("base64", ConvertTools.base64Encode((byte[])file.getBytes()));
            return message;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, Object> uploadFileToOSS(MultipartFile file) {
        throw new RuntimeException("\u6682\u672a\u5b9e\u73b0OSS\u5bf9\u8c61\u5b58\u50a8\u6a21\u5f0f");
    }

    public static class FileUploadResult {
        private final Boolean isSuccess;
        private final Object data;

        private FileUploadResult(boolean isSuccess, Object data) {
            this.isSuccess = isSuccess;
            this.data = data;
        }

        public Boolean getSuccess() {
            return this.isSuccess;
        }

        public Object getData() {
            return this.data;
        }
    }
}

