/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExceptionLogService {
    private static final String HIBERNATE_SQL_EXCEPTION = "org.hibernate.exception.SQLGrammarException";
    private static final String EXPRESSION_EXCEPTION = "com.af.v4.system.expression.exception.ExpressionException";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionLogService.class);

    public static String getErrorInfo(String errorInfo, BusinessType type) {
        String result;
        try {
            String defaultHeader = "ERROR!======\n";
            String defaultHeaderEnd = "\nERROR_END!=====";
            StringBuilder builder = new StringBuilder(defaultHeader);
            if (type == BusinessType.LOGIC) {
                ExceptionLogService.appendLogicErrorInfo(builder, errorInfo);
            } else {
                ExceptionLogService.appendSqlErrorInfo(builder, errorInfo);
            }
            builder.append(defaultHeaderEnd);
            result = builder.toString();
            if (result.equals(defaultHeader + defaultHeaderEnd)) {
                result = errorInfo;
            }
        }
        catch (Exception e) {
            LOGGER.error("***\u62a5\u9519\u5806\u6808\u622a\u53d6\u62a5\u9519***", (Throwable)e);
            result = errorInfo;
        }
        return result;
    }

    private static void appendSqlErrorInfo(StringBuilder result, String errorInfo) {
        int endIndex;
        String keySentences = "org.hibernate.exception.SQLGrammarException: sql:\n";
        int ignoreIndex = errorInfo.indexOf(keySentences);
        if (ignoreIndex != -1 && (endIndex = errorInfo.indexOf("could not extract ResultSet")) != -1) {
            String head = errorInfo.substring(ignoreIndex + keySentences.length(), endIndex);
            result.append(head).append("=====\n");
        }
        if ((ignoreIndex = errorInfo.lastIndexOf("Caused by:")) != -1) {
            result.append(errorInfo.substring(ignoreIndex));
        }
    }

    private static void appendLogicErrorInfo(StringBuilder result, String errorInfo) {
        String keySentences = "com.af.v4.system.expression.exception.ExpressionException: ";
        int ignoreIndex = errorInfo.indexOf(keySentences);
        if (ignoreIndex != -1) {
            int ignoreIndexEnd = (errorInfo = errorInfo.substring(ignoreIndex + keySentences.length())).indexOf("at ");
            if (ignoreIndexEnd != -1) {
                result.append(errorInfo, 0, ignoreIndexEnd).append("\n=====\n");
                errorInfo = errorInfo.substring(ignoreIndexEnd + 3);
                ExceptionLogService.appendLogicErrorInfo(result, errorInfo);
            }
        } else {
            ignoreIndex = errorInfo.lastIndexOf("Caused by:");
            if (ignoreIndex != -1) {
                result.append(errorInfo.substring(ignoreIndex));
            }
        }
    }

    static enum BusinessType {
        LOGIC,
        SQL;

    }
}

