/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.service;

import com.af.v4.system.api.RemoteEntityService;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.plugins.core.CommonTools;
import com.af.v4.system.plugins.io.IOTools;
import com.af.v4.system.restful.config.DynamicDataSourceConfig;
import com.af.v4.system.restful.enums.entity.ColumnTypeEnum;
import com.af.v4.system.restful.enums.entity.DialectTypeEnum;
import com.af.v4.system.restful.enums.entity.IDTypeEnum;
import com.af.v4.system.restful.sql.SqlAction;
import com.af.v4.system.restful.sql.TransformerSupport;
import com.af.v4.system.restful.transaction.SessionPool;
import com.af.v4.system.restful.utils.Pair;
import com.alibaba.druid.pool.DruidDataSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.Assigned;
import org.hibernate.id.ForeignGenerator;
import org.hibernate.id.GUIDGenerator;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.id.IdentityGenerator;
import org.hibernate.id.UUIDGenerator;
import org.hibernate.id.UUIDHexGenerator;
import org.hibernate.id.enhanced.SequenceStyleGenerator;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.SessionImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.NativeQuery;
import org.hibernate.type.CollectionType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class EntityService
implements TransformerSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityService.class);
    private static Map<String, Map<String, String>> SUBCLASS_MODULE_MAP;
    private static final HashMap<String, Map<String, Object>> META_MAP;
    private static final HashMap<String, String> ENTITY_LIFT_MAP;
    private final SessionPool sessionPool;
    private final SqlAction sqlAction;
    private final DynamicDataSourceConfig dynamicDataSourceConfig;
    private final RemoteEntityService remoteEntityService;

    public EntityService(SessionPool sessionPool, SqlAction sqlAction, DynamicDataSourceConfig dynamicDataSourceConfig, RemoteEntityService remoteEntityService) {
        this.sessionPool = sessionPool;
        this.sqlAction = sqlAction;
        this.dynamicDataSourceConfig = dynamicDataSourceConfig;
        this.remoteEntityService = remoteEntityService;
    }

    public static DialectTypeEnum getDialectType() {
        DruidDataSource dataSource = DynamicDataSource.getDruidDataSource();
        DialectTypeEnum dialectType = DialectTypeEnum.toType(dataSource.getDriverClassName());
        if (dialectType == DialectTypeEnum.DIALECT_NOT_SUPPORTED) {
            throw new RuntimeException("\u6570\u636e\u5e93\u65b9\u8a00\u914d\u7f6e\u5f02\u5e38\u3002");
        }
        return dialectType;
    }

    public static String getDialectTypeStr() {
        return EntityService.getDialectType().getValue();
    }

    public static Map<String, Map<String, String>> getSubClassMap() {
        return SUBCLASS_MODULE_MAP;
    }

    @PostConstruct
    public void init() {
        this.loadSubclassMap();
        this.loadMetaData();
    }

    public Integer delete(String entityName, Object id) {
        Map<String, Object> map = META_MAP.get(entityName);
        String sql = "DELETE FROM " + map.get("tableName") + " WHERE " + map.get("idName") + " = '" + id + "'";
        return this.sqlAction.bulkSQLUpdate("EntityService@Delete", sql);
    }

    public JSONObject remoteDelete(String serviceName, String entityName, Object id) {
        R result = this.remoteEntityService.deleteById(serviceName, entityName, String.valueOf(id), "inner");
        return result.parseResponseJson();
    }

    public Integer deleteAllByIds(String entityName, JSONArray ids) {
        Map<String, Object> map = META_MAP.get(entityName);
        String idStr = CommonTools.union((JSONArray)ids);
        String sql = "DELETE FROM " + map.get("tableName") + " WHERE " + map.get("idName") + " IN (" + idStr + " )";
        return this.sqlAction.bulkSQLUpdate("EntityService@deleteAllByIds", sql);
    }

    public JSONObject remoteDeleteAllByIds(String serviceName, String entityName, JSONArray ids) {
        JSONObject params = new JSONObject();
        params.put("ids", (Object)ids);
        R result = this.remoteEntityService.deleteAllByIds(serviceName, entityName, params.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONArray findAllByIds(String columns, String entityName, JSONArray ids) {
        Map<String, Object> map = META_MAP.get(entityName);
        String idStr = CommonTools.union((JSONArray)ids);
        String sql = "SELECT " + columns + " FROM " + map.get("tableName") + " WHERE " + map.get("idName") + " IN (" + idStr + " )";
        return this.sqlAction.queryAll("EntityService@findAllByIds", sql);
    }

    public JSONArray findAllByIds(String entityName, JSONArray ids) {
        return this.findAllByIds("*", entityName, ids);
    }

    public JSONObject remoteFindAllByIds(String serviceName, String columns, String entityName, JSONArray ids) {
        JSONObject params = new JSONObject();
        params.put("columns", (Object)columns);
        params.put("ids", (Object)ids);
        R result = this.remoteEntityService.findAllByIds(serviceName, entityName, params.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteFindAllByIds(String serviceName, String entityName, JSONArray ids) {
        return this.remoteFindAllByIds(serviceName, null, entityName, ids);
    }

    public Long getCount(String entityName) {
        Map<String, Object> map = META_MAP.get(entityName);
        String sql = "SELECT COUNT(0) count FROM " + map.get("tableName");
        JSONArray result = this.sqlAction.queryAll("EntityService@getCount", sql);
        return result.length() > 0 ? result.getJSONObject(0).getLong("count") : 0L;
    }

    public JSONObject remoteGetCount(String serviceName, String entityName) {
        R result = this.remoteEntityService.getCount(serviceName, entityName, "inner");
        return result.parseResponseJson();
    }

    public JSONArray findAll(String columns, String entityName) {
        Map<String, Object> map = META_MAP.get(entityName);
        String sql = "SELECT " + columns + " FROM " + map.get("tableName");
        return this.sqlAction.queryAll("EntityService@findAll", sql);
    }

    public JSONArray findAll(String entityName) {
        return this.findAll("*", entityName);
    }

    public JSONObject remoteFindAll(String serviceName, String columns, String entityName) {
        JSONObject params = new JSONObject();
        params.put("columns", (Object)columns);
        R result = this.remoteEntityService.findAll(serviceName, entityName, params.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteFindAll(String serviceName, String entityName) {
        return this.remoteFindAll(serviceName, "*", entityName);
    }

    public JSONObject getById(String columns, String entityName, Object id) {
        Map<String, Object> map = META_MAP.get(entityName);
        String sql = "SELECT " + columns + " FROM " + map.get("tableName") + " WHERE " + map.get("idName") + " = '" + id + "'";
        JSONArray result = this.sqlAction.queryAll("EntityService@getById", sql);
        if (result.length() == 0) {
            return null;
        }
        return result.getJSONObject(0);
    }

    public JSONObject getById(String entityName, Object id) {
        return this.getById("*", entityName, String.valueOf(id));
    }

    public JSONObject remoteGetById(String serviceName, String columns, String entityName, Object id) {
        JSONObject params = new JSONObject();
        params.put("columns", (Object)columns);
        R result = this.remoteEntityService.getById(serviceName, entityName, String.valueOf(id), params.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONObject remoteGetById(String serviceName, String entityName, Object id) {
        return this.remoteGetById(serviceName, "*", entityName, String.valueOf(id));
    }

    public JSONObject partialSave(String entityName, JSONObject row) throws Exception {
        return this.partialSave(entityName, new JSONArray().put((Object)row)).getJSONObject(0);
    }

    public JSONObject remotePartialSave(String serviceName, String entityName, JSONObject row) {
        R result = this.remoteEntityService.save(serviceName, entityName, row.toString(), "inner");
        return result.parseResponseJson();
    }

    public JSONArray partialSave(String entityName, JSONArray rowArray) throws Exception {
        Map md;
        if (ENTITY_LIFT_MAP.containsKey(entityName)) {
            String pEntityName = ENTITY_LIFT_MAP.get(entityName);
            md = this.deepClone((HashMap)META_MAP.get(pEntityName));
            this.enchanceMetaData(md, entityName);
        } else {
            md = META_MAP.get(entityName);
        }
        if (md == null) {
            throw new ServiceException("\u5b9e\u4f53[" + entityName + "]\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173hibernate\u6587\u4ef6");
        }
        List<Serializable> aid = this.partialSave(rowArray, md, null);
        JSONArray result = new JSONArray(aid.size());
        aid.forEach(item -> {
            JSONObject obj = new JSONObject();
            obj.put((String)md.get("idName"), (Object)item.toString());
            result.put((Object)obj);
        });
        return result;
    }

    public JSONObject remotePartialSave(String serviceName, String entityName, JSONArray rowArray) {
        R result = this.remoteEntityService.saveBatch(serviceName, entityName, rowArray.toString(), "inner");
        return result.parseResponseJson();
    }

    private void partialSave(JSONObject row, Map<String, Object> md, Object pIdValue) {
        JSONArray array = new JSONArray(1);
        array.put((Object)row);
        this.partialSave(array, md, pIdValue);
    }

    private List<Serializable> partialSave(JSONArray rowArray, Map<String, Object> md, Object pIdValue) {
        ArrayList<Serializable> result = new ArrayList<Serializable>(rowArray.length());
        rowArray.forEach(item -> {
            int affectedRows;
            JSONObject row = (JSONObject)item;
            Object idValue = null;
            String idName = (String)md.get("idName");
            String idType = (String)md.get("idType");
            if (row.has(idName)) {
                idValue = row.get(idName);
            }
            HashMap columns = (HashMap)md.get("columns");
            HashMap links = (HashMap)md.get("links");
            boolean isInsert = false;
            if (idValue == null) {
                affectedRows = this.doInsert(row, md, pIdValue, idName, idType, columns);
            } else if (IDTypeEnum.toType((String)md.get("idGenerator")) != IDTypeEnum.ID_ASSIGNED) {
                affectedRows = this.doUpdate(row, md, idValue, idType, columns);
            } else if (this.hasKeyRow((String)md.get("tableName"), (String)md.get("idColName"), idValue, idType)) {
                affectedRows = this.doUpdate(row, md, idValue, idType, columns);
            } else {
                isInsert = true;
                affectedRows = this.doInsert(row, md, pIdValue, idName, idType, columns);
            }
            if (affectedRows == 0) {
                throw new ServiceException("\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u8fd4\u56de\u7684\u5f71\u54cd\u884c\u6570\u4e3a:0\uff0c\u53ef\u80fd\u662f\u4ee5\u4e0b\u539f\u56e0\u4e4b\u4e00\uff1a1.\u6709\u5176\u4ed6\u4e1a\u52a1\u540c\u65f6\u4fee\u6539\u8be5\u6761\u6570\u636e\u5bfc\u81f4\u89e6\u53d1hibernate\u4e50\u89c2\u9501\uff0c\u8bf7\u68c0\u7d22\uff1ahibernate\u4e50\u89c2\u9501\u30022.update\u7684\u6761\u4ef6\u8868\u8fbe\u5f0f\u6709\u8bef");
            }
            idValue = row.get(idName);
            if (isInsert) {
                row.remove(idName);
            }
            Iterator itr = row.keys();
            while (itr.hasNext()) {
                String attr = (String)itr.next();
                if (!links.containsKey(attr) || !row.has(attr)) continue;
                Pair pair = (Pair)links.get(attr);
                Map<String, Object> cmd = META_MAP.get(pair.col);
                if (row.isNull(attr)) continue;
                this.doSave(row, idValue, attr, cmd);
            }
            result.add((Serializable)idValue);
        });
        return result;
    }

    private void doSave(JSONObject row, Object idValue, String attr, Map<String, Object> cmd) {
        Object obj = row.get(attr);
        if (obj instanceof JSONArray) {
            JSONArray rows = row.getJSONArray(attr);
            for (int i = 0; i < rows.length(); ++i) {
                this.partialSave(rows.getJSONObject(i), cmd, idValue);
            }
        } else {
            this.partialSave((JSONObject)obj, cmd, idValue);
        }
    }

    private boolean hasKeyRow(String tableName, String idColName, Object idValue, String idType) {
        return this.sessionPool.getSession().createSQLQuery("select 1 from " + tableName + " where " + idColName + "=" + this.normalizeValue(idValue, idType)).list().size() > 0;
    }

    private int doUpdate(JSONObject row, Map<String, Object> md, Object idValue, String idType, HashMap<String, Pair> columns) {
        if (row.keySet().size() == 1) {
            return -1;
        }
        Object verValue = null;
        String verName = (String)md.get("verName");
        String verType = (String)md.get("verType");
        if (verName != null && row.has(verName)) {
            verValue = row.get(verName);
        }
        StringBuilder sb = new StringBuilder();
        if (verName != null) {
            sb.append(" ").append(verName).append("=").append(this.normalizeVer(verValue, verType)).append(", ");
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr = (String)itr.next();
            if (!columns.containsKey(attr) || attr.equals(verName)) continue;
            Pair pair = columns.get(attr);
            sb.append(" ").append(pair.col).append("=").append((String)(row.isNull(attr) ? "null, " : this.normalizeValue(row.get(attr), pair.type) + ", "));
        }
        if (sb.length() == 0) {
            LOGGER.error("\u63d0\u4ea4\u7684\u6570\u636e\u9519\u8bef\uff1a" + row);
            throw new RuntimeException("\u63d0\u4ea4\u7684\u6570\u636e\u9519\u8bef\uff1a" + row);
        }
        sb.delete(sb.length() - 2, sb.length());
        sb.insert(0, "update " + md.get("tableName") + " set ");
        sb.append(" where ").append(md.get("idColName")).append(" = ").append(this.normalizeValue(idValue, idType));
        if (md.get("verName") != null) {
            sb.append(" and ").append(md.get("verColName")).append("=").append(this.normalizeValue(verValue, verType));
        }
        LOGGER.info("\u751f\u6210\u7684\u66f4\u65b0sql: " + sb);
        int affectedRow = this.SQLUpdate(sb.toString());
        if (md.containsKey("subclasses")) {
            HashMap subclasses = (HashMap)md.get("subclasses");
            for (String sentity : subclasses.keySet()) {
                Pair p = (Pair)subclasses.get(sentity);
                if (row.isNull(p.col)) break;
                String dv = row.getString(p.col);
                if (!p.type.equals(dv) && !p.type.contains(dv + ",") && !p.type.contains("," + dv)) continue;
                StringBuilder buf = new StringBuilder();
                Map<String, Object> smd = META_MAP.get(sentity);
                String keyAttr = (String)smd.get("idName");
                HashMap attrs = (HashMap)smd.get("columns");
                for (String attr : attrs.keySet()) {
                    if (attr.equals(keyAttr) || !row.has(attr)) continue;
                    p = (Pair)attrs.get(attr);
                    buf.append(p.col).append("=").append(this.normalizeValue(row.isNull(attr) ? null : row.get(attr), p.type)).append(", ");
                }
                buf.delete(buf.length() - 2, buf.length());
                buf.insert(0, "update " + smd.get("tableName") + " set ");
                buf.append(" where ").append(smd.get("idColName")).append(" = ").append(this.normalizeValue(idValue, idType));
                LOGGER.info("\u751f\u6210\u7684\u5b50\u66f4\u65b0sql: " + buf);
                this.SQLUpdate(buf.toString());
                HashMap links = (HashMap)smd.get("links");
                HashMap pLinks = (HashMap)md.get("links");
                Iterator itrLink = row.keys();
                while (itrLink.hasNext()) {
                    String attr = (String)itrLink.next();
                    if (pLinks.containsKey(attr) || !links.containsKey(attr) || !row.has(attr)) continue;
                    Pair pair = (Pair)links.get(attr);
                    Map<String, Object> cmd = META_MAP.get(pair.col);
                    if (row.isNull(attr)) continue;
                    this.doSave(row, idValue, attr, cmd);
                }
                break block1;
            }
        }
        this.handleInverses(row, md);
        return affectedRow;
    }

    private void handleInverses(JSONObject row, Map<String, Object> md) {
        HashMap inverses = (HashMap)md.get("inverses");
        for (String inverse : inverses.keySet()) {
            Object arow;
            if (row.isNull(inverse) || !((arow = row.get(inverse)) instanceof JSONObject)) continue;
            Map<String, Object> amd = META_MAP.get(inverses.get(inverse));
            this.partialSave((JSONObject)arow, amd, null);
        }
    }

    private int doInsert(JSONObject row, Map<String, Object> md, Object pIdValue, String idName, String idType, HashMap<String, Pair> columns) {
        int affectedRows;
        Object verValue = null;
        String verName = (String)md.get("verName");
        String verType = (String)md.get("verType");
        if (verName != null && row.has(verName)) {
            verValue = row.get(verName);
        }
        String idColName = (String)md.get("idColName");
        StringBuilder sbCols = new StringBuilder();
        StringBuilder sbValues = new StringBuilder();
        if (verName != null) {
            sbCols.append(verName).append(", ");
            sbValues.append(this.normalizeVer(verValue, verType)).append(", ");
        }
        Iterator itr = row.keys();
        while (itr.hasNext()) {
            String attr = (String)itr.next();
            if (!columns.containsKey(attr) || attr.equals(verName)) continue;
            Pair pair = columns.get(attr);
            sbCols.append(pair.col).append(", ");
            sbValues.append((String)(row.isNull(attr) ? "null, " : this.normalizeValue(row.get(attr), pair.type) + ", "));
        }
        String idStrategy = (String)md.get("idGenerator");
        IDTypeEnum idTypeEnum = IDTypeEnum.toType(idStrategy);
        switch (idTypeEnum) {
            case ID_GUID: {
                sbCols.append(idColName).append(", ");
                String guid = UUID.randomUUID().toString().replace("-", "");
                sbValues.append("'").append(guid).append("', ");
                row.put(idName, (Object)guid);
                break;
            }
            case ID_SEQ: {
                sbCols.append(idColName).append(", ");
                String aid = this.getLastSeqId((String)md.get("sequence"));
                sbValues.append(aid).append(", ");
                row.put(idName, (Object)aid);
                break;
            }
            case ID_ASSIGNED: {
                sbCols.append(idColName).append(", ");
                sbValues.append(this.normalizeValue(row.get(idName), idType)).append(", ");
                row.put(idName, row.get(idName));
                break;
            }
            case ID_FOREIGNER: {
                sbCols.append(idColName).append(", ");
                String aid = this.normalizeValue(pIdValue, idType);
                sbValues.append(aid).append(", ");
                row.put(idName, (Object)aid);
                break;
            }
        }
        if (md.containsKey("inverses")) {
            HashMap inverses = (HashMap)md.get("inverses");
            HashMap inversesid = (HashMap)md.get("inverseid");
            for (String inverse : inverses.keySet()) {
                Pair pair;
                if (row.isNull(inverse)) continue;
                Object arow = row.get(inverse);
                if (!(arow instanceof JSONObject)) {
                    pair = (Pair)inversesid.get(inverse);
                    sbCols.append(pair.col).append(", ");
                    sbValues.append(this.normalizeValue(arow, pair.type)).append(", ");
                    continue;
                }
                JSONObject json = (JSONObject)arow;
                sbCols.append(inverse).append(", ");
                pair = (Pair)inversesid.get(inverse);
                arow = json.get(pair.col);
                sbValues.append(this.normalizeValue(arow, pair.type)).append(", ");
            }
        }
        sbCols.delete(sbCols.length() - 2, sbCols.length());
        sbCols.insert(0, "insert into " + md.get("tableName") + " (");
        sbValues.delete(sbValues.length() - 2, sbValues.length());
        sbCols.append(") values (");
        sbCols.append((CharSequence)sbValues);
        sbCols.append(")");
        LOGGER.info("\u751f\u6210\u7684\u63d2\u5165sql\uff1b" + sbCols);
        if (idTypeEnum == IDTypeEnum.ID_AUTO) {
            Pair pair;
            try {
                pair = this.rawJdbcUpdate(sbCols.toString());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            row.put(idName, (Object)pair.type);
            affectedRows = Integer.parseInt(pair.col);
        } else {
            affectedRows = this.SQLUpdate(sbCols.toString());
        }
        if (md.containsKey("subclasses")) {
            HashMap subclasses = (HashMap)md.get("subclasses");
            for (String sentity : subclasses.keySet()) {
                Pair pair;
                Pair p = (Pair)subclasses.get(sentity);
                if (row.isNull(p.col)) break;
                String dv = row.getString(p.col);
                if (!p.type.equals(dv) && !p.type.contains(dv + ",") && !p.type.contains("," + dv)) continue;
                StringBuilder buf = new StringBuilder();
                StringBuilder vals = new StringBuilder();
                Map<String, Object> smd = META_MAP.get(sentity);
                String keyCol = (String)smd.get("idColName");
                buf.append(keyCol).append(", ");
                vals.append(this.normalizeValue(row.get(idName), idType)).append(", ");
                HashMap attrs = (HashMap)smd.get("columns");
                for (Object attr : attrs.keySet()) {
                    if (!row.has((String)attr)) continue;
                    p = (Pair)attrs.get(attr);
                    buf.append(p.col).append(", ");
                    vals.append(this.normalizeValue(row.isNull((String)attr) ? null : row.get((String)attr), p.type)).append(", ");
                }
                if (smd.containsKey("inverseid")) {
                    HashMap lookup = (HashMap)smd.get("inverseid");
                    for (String property : lookup.keySet()) {
                        if (!row.has(property) || row.isNull(property)) continue;
                        Object obj = row.get(property);
                        pair = (Pair)lookup.get(property);
                        if (obj instanceof JSONObject) {
                            JSONObject record = (JSONObject)obj;
                            if (!record.has(pair.col) || record.isNull(pair.col)) continue;
                            buf.append(pair.col).append(", ");
                            vals.append(this.normalizeValue(record.get(pair.col), pair.type)).append(", ");
                            continue;
                        }
                        buf.append(pair.col).append(", ");
                        vals.append(this.normalizeValue(row.get(property), pair.type)).append(", ");
                    }
                }
                buf.delete(buf.length() - 2, buf.length());
                vals.delete(vals.length() - 2, vals.length());
                buf.insert(0, "insert into " + smd.get("tableName") + " (");
                buf.append(") values (");
                buf.append((CharSequence)vals);
                buf.append(")");
                LOGGER.info("\u751f\u6210\u7684\u5b50\u63d2\u5165sql: " + buf);
                this.SQLUpdate(buf.toString());
                HashMap links = (HashMap)smd.get("links");
                HashMap pLinks = (HashMap)md.get("links");
                Iterator itrLink = row.keys();
                while (itrLink.hasNext()) {
                    String attr = (String)itrLink.next();
                    if (pLinks.containsKey(attr) || !links.containsKey(attr) || !row.has(attr)) continue;
                    pair = (Pair)links.get(attr);
                    Map<String, Object> cmd = META_MAP.get(pair.col);
                    if (row.isNull(attr)) continue;
                    Object obj = row.get(attr);
                    if (obj instanceof JSONArray) {
                        JSONArray rows = row.getJSONArray(attr);
                        for (int i = 0; i < rows.length(); ++i) {
                            this.partialSave(rows.getJSONObject(i), cmd, row.get(idName));
                        }
                        continue;
                    }
                    this.partialSave((JSONObject)obj, cmd, row.get(idName));
                }
                break block10;
            }
        }
        this.handleInverses(row, md);
        return affectedRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair rawJdbcUpdate(String sql) throws Exception {
        Pair pair = new Pair("", "");
        Connection con = ((SessionImpl)this.sessionPool.getSession()).connection();
        PreparedStatement statement = con.prepareStatement(sql, 1);
        ResultSet rs = null;
        try {
            int affectedRows = statement.executeUpdate();
            pair.col = "" + affectedRows;
            if (affectedRows == 0) {
                Pair pair2 = pair;
                return pair2;
            }
            rs = statement.getGeneratedKeys();
            if (!rs.next()) {
                throw new Exception("\u5f97\u5230\u63d2\u5165\u8bb0\u5f55id\u5931\u8d25\u3002");
            }
            pair.type = "" + rs.getLong(1);
            Pair pair3 = pair;
            return pair3;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    private int SQLUpdate(String sql) {
        NativeQuery query = this.sessionPool.getSession().createNativeQuery(sql);
        return query.executeUpdate();
    }

    private String query(String sql) {
        NativeQuery query = this.sessionPool.getSession().createNativeQuery(sql);
        return "" + query.list().get(0);
    }

    private String getLastSeqId(String seq) {
        return this.query("select " + seq + ".nextval newid from dual");
    }

    private String normalizeVer(Object verValue, String verType) {
        DialectTypeEnum dialectType = EntityService.getDialectType();
        if (ColumnTypeEnum.toType(verType) == ColumnTypeEnum.COL_TIME) {
            if (dialectType == DialectTypeEnum.DIALECT_ORACLE) {
                return "current_timestamp";
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return "'" + sdf.format(new Date()) + "'";
        }
        if (verValue == null) {
            return "1";
        }
        return "" + (Integer.parseInt("" + verValue) + 1);
    }

    private String normalizeValue(Object value, String valType) {
        if (value == null) {
            return "null";
        }
        ColumnTypeEnum columnTypeEnum = ColumnTypeEnum.toType(valType);
        DialectTypeEnum dialectType = EntityService.getDialectType();
        switch (columnTypeEnum) {
            case COL_STRING: {
                return "'" + value + "'";
            }
            case COL_NUMBER: {
                if ("".equals(value)) {
                    return "null";
                }
                return "" + value;
            }
            case COL_BOOLEAN: {
                if (dialectType == DialectTypeEnum.DIALECT_ORACLE) {
                    return "'" + ((Boolean)value != false ? "Y" : "N") + "'";
                }
                if (value instanceof Byte) {
                    return value.toString();
                }
                if (value instanceof Integer) {
                    return value.toString();
                }
                return (Boolean)value != false ? "1" : "0";
            }
            case COL_DATE: {
                if (dialectType == DialectTypeEnum.DIALECT_ORACLE) {
                    return "TO_DATE(SUBSTR('" + value + "', 1, 10), 'YYYY-MM-DD')";
                }
                return "'" + value + "'";
            }
            case COL_TIME: {
                if (dialectType == DialectTypeEnum.DIALECT_ORACLE) {
                    return "TO_TIMESTAMP('" + value + "', 'YYYY-MM-DD HH24:MI:SS')";
                }
                return "'" + value + "'";
            }
        }
        throw new ServiceException("\u4f20\u9012\u6570\u636e\u7c7b\u578b\u51fa\u9519");
    }

    public void loadSubclassMap() {
        SUBCLASS_MODULE_MAP = new LinkedHashMap<String, Map<String, String>>();
        List<String> subClassList = this.dynamicDataSourceConfig.getSubClass();
        if (subClassList != null) {
            for (String name : subClassList) {
                HashMap<String, String> module = new HashMap<String, String>(1);
                module.put("name", name);
                SUBCLASS_MODULE_MAP.put(name, module);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void loadMetaData() {
        MetamodelImplementor metaModelImpl = this.sessionPool.getSessionFactory().getMetamodel();
        Map entityPersisterMap = metaModelImpl.entityPersisters();
        Collection val = entityPersisterMap.values();
        LinkedHashMap<String, AbstractEntityPersister> map = new LinkedHashMap<String, AbstractEntityPersister>(val.size());
        for (EntityPersister ep : val) {
            AbstractEntityPersister aep = (AbstractEntityPersister)ep;
            map.put(aep.getEntityName(), aep);
        }
        for (String entityName : map.keySet()) {
            try {
                this.getMetaData(entityName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        SAXReader reader = new SAXReader();
        IOTools.getStream((String)"subclass.xml", stream -> this.loadSubclass(reader, stream));
        Map<String, Map<String, String>> maps = EntityService.getSubClassMap();
        for (String string : maps.keySet()) {
            void var8_9;
            if (!"".equals(string)) {
                String string2 = string + "/";
            }
            void finalModuleName = var8_9;
            IOTools.getStream((String)("/" + (String)finalModuleName + "subclass.xml"), stream -> this.loadSubclass(reader, stream), arg_0 -> EntityService.lambda$loadMetaData$4((String)finalModuleName, arg_0));
        }
        for (String string : map.keySet()) {
            try {
                Map<String, Object> hash = META_MAP.get(string);
                if (hash != null) {
                    ClassMetadata cmd = this.sessionPool.getSessionFactory().getClassMetadata(string);
                    HashMap<String, String> inverses = new HashMap<String, String>(16);
                    hash.put("inverses", inverses);
                    HashMap<String, Pair> inverseMap = new HashMap<String, Pair>(16);
                    hash.put("inverseid", inverseMap);
                    for (String property : cmd.getPropertyNames()) {
                        Type type = cmd.getPropertyType(property);
                        if (!(type instanceof ManyToOneType)) continue;
                        ManyToOneType mto = (ManyToOneType)type;
                        String linkedEntity = mto.getAssociatedEntityName();
                        String colName = mto.getAssociatedJoinable((SessionFactoryImplementor)this.sessionPool.getSessionFactory()).getKeyColumnNames()[0];
                        inverses.put(property, linkedEntity);
                        inverseMap.put(property, new Pair(colName, (String)META_MAP.get(linkedEntity).get("idType")));
                    }
                    continue;
                }
                LOGGER.warn("\u672a\u5904\u7406\u3010" + string + "\u3011\u7684\u53cd\u5411\u591a\u5bf9\u4e00\u5173\u7cfb\uff0c\u53ef\u80fd\u542b\u6709\u4e0d\u652f\u6301\u7684\u6620\u5c04\u7ed3\u6784");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void loadSubclass(SAXReader reader, InputStream input) {
        try {
            Document document = reader.read(input);
            Element root = document.getRootElement();
            Iterator it = root.elementIterator("entity");
            while (it.hasNext()) {
                HashMap<String, Pair> subclasses;
                Element elm = (Element)it.next();
                String entityName = elm.attribute("name").getValue();
                String parentEntity = elm.attribute("parentEntity").getValue();
                String discProperty = elm.attribute("discProperty").getValue();
                String discriminator = elm.attribute("discriminator").getValue();
                if (!META_MAP.containsKey(parentEntity)) continue;
                Map<String, Object> em = META_MAP.get(parentEntity);
                if (em.containsKey("subclasses")) {
                    subclasses = (HashMap<String, Pair>)em.get("subclasses");
                } else {
                    subclasses = new HashMap<String, Pair>(1);
                    em.put("subclasses", subclasses);
                }
                subclasses.put(entityName, new Pair(discProperty, discriminator));
                ENTITY_LIFT_MAP.put(entityName, parentEntity);
            }
        }
        catch (DocumentException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String normalizeType(String type) {
        return switch (type = type.toLowerCase()) {
            case "string" -> ColumnTypeEnum.COL_STRING.getValue();
            case "date" -> ColumnTypeEnum.COL_DATE.getValue();
            case "time", "timestamp" -> ColumnTypeEnum.COL_TIME.getValue();
            case "boolean", "yes_no" -> ColumnTypeEnum.COL_BOOLEAN.getValue();
            case "integer", "double", "big_decimal", "big_integer" -> ColumnTypeEnum.COL_NUMBER.getValue();
            default -> ColumnTypeEnum.COL_NOT_SUPPORTED.getValue();
        };
    }

    private void getMetaData(String entityName) throws Exception {
        if (META_MAP.containsKey(entityName)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(12);
        map.put("entityName", entityName);
        ClassMetadata cmd = this.sessionPool.getSessionFactory().getClassMetadata(entityName);
        AbstractEntityPersister aep = (AbstractEntityPersister)cmd;
        map.put("tableName", aep.getTableName());
        String attr = cmd.getIdentifierPropertyName();
        if (attr == null) {
            LOGGER.warn("\u505c\u6b62\u5904\u7406\u3010" + entityName + "\u3011\u7684\u6620\u5c04\uff0c\u53ef\u80fd\u542b\u6709\u4e0d\u652f\u6301\u7684\u6620\u5c04\u7ed3\u6784");
            return;
        }
        map.put("idName", attr);
        map.put("idColName", aep.getPropertyColumnNames(attr)[0]);
        String idType = this.normalizeType(cmd.getIdentifierType().getName());
        map.put("idType", idType);
        IdentifierGenerator idg = aep.getIdentifierGenerator();
        if (idg instanceof GUIDGenerator || idg instanceof UUIDGenerator || idg instanceof UUIDHexGenerator) {
            map.put("idGenerator", IDTypeEnum.ID_GUID.getValue());
        } else if (idg instanceof SequenceStyleGenerator) {
            SequenceStyleGenerator generator = (SequenceStyleGenerator)idg;
            String name = generator.getDatabaseStructure().getPhysicalName().render();
            map.put("sequence", name);
            map.put("idGenerator", IDTypeEnum.ID_SEQ.getValue());
        } else if (idg instanceof IdentityGenerator) {
            map.put("idGenerator", IDTypeEnum.ID_AUTO.getValue());
        } else if (idg instanceof Assigned) {
            map.put("idGenerator", IDTypeEnum.ID_ASSIGNED.getValue());
        } else if (idg instanceof ForeignGenerator) {
            map.put("idGenerator", IDTypeEnum.ID_FOREIGNER.getValue());
        } else {
            throw new Exception("Unsupported id generator strategy:" + idg.getClass().getName());
        }
        if (cmd.isVersioned()) {
            attr = cmd.getPropertyNames()[cmd.getVersionProperty()];
            map.put("verName", attr);
            map.put("verColName", aep.getPropertyColumnNames(attr)[0]);
            map.put("verType", this.normalizeType(cmd.getPropertyType(attr).getName()));
        }
        HashMap<String, Pair> columns = new HashMap<String, Pair>(1);
        map.put("columns", columns);
        HashMap<String, Pair> links = new HashMap<String, Pair>(1);
        map.put("links", links);
        HashMap<String, Pair> onetoone = new HashMap<String, Pair>(1);
        map.put("onetoone", onetoone);
        HashMap<String, Pair> onetomany = new HashMap<String, Pair>(1);
        map.put("onetomany", onetomany);
        for (String property : cmd.getPropertyNames()) {
            Type type = cmd.getPropertyType(property);
            if (type instanceof CollectionType || type instanceof OneToOneType) {
                String linkEntity;
                Joinable ja;
                SessionFactoryImpl sf = this.sessionPool.getSessionFactory();
                if (type instanceof CollectionType) {
                    CollectionType st = (CollectionType)type;
                    ja = st.getAssociatedJoinable((SessionFactoryImplementor)sf);
                    linkEntity = st.getAssociatedEntityName((SessionFactoryImplementor)sf);
                } else {
                    OneToOneType st = (OneToOneType)type;
                    ja = st.getAssociatedJoinable((SessionFactoryImplementor)sf);
                    linkEntity = st.getAssociatedEntityName((SessionFactoryImplementor)sf);
                }
                String foreignKey = ja.getKeyColumnNames()[0];
                String link = type instanceof OneToOneType ? property : ja.getName().substring(entityName.length() + 1);
                links.put(link, new Pair(linkEntity, foreignKey));
                if (type instanceof CollectionType) {
                    onetomany.put(link, new Pair(linkEntity, foreignKey));
                    continue;
                }
                onetoone.put(link, new Pair(linkEntity, foreignKey));
                continue;
            }
            if (type instanceof ManyToOneType) continue;
            String columnName = ((AbstractEntityPersister)cmd).getPropertyColumnNames(property)[0];
            columns.put(property, new Pair(columnName, this.normalizeType(type.getName())));
        }
        META_MAP.put(entityName, map);
    }

    public <T extends Serializable> T deepClone(T o) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteOut);
        out.writeObject(o);
        out.flush();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(byteOut.toByteArray()));
        return (T)((Serializable)o.getClass().cast(in.readObject()));
    }

    private void enchanceMetaData(Map<String, Object> pmd, String entityName) throws Exception {
        Map<String, Object> md = META_MAP.get(entityName);
        HashMap links = (HashMap)md.get("links");
        HashMap plinks = (HashMap)pmd.get("links");
        for (String key : links.keySet()) {
            plinks.put(key, this.deepClone((Pair)links.get(key)));
        }
        HashMap sub = md.containsKey("subclasses") ? (HashMap)md.get("subclasses") : new HashMap(0);
        HashMap<String, Pair> psub = pmd.containsKey("subclasses") ? (HashMap<String, Pair>)pmd.get("subclasses") : new HashMap<String, Pair>(sub.size());
        for (String key : sub.keySet()) {
            psub.put(key, this.deepClone((Pair)sub.get(key)));
        }
        HashMap inv = (HashMap)md.get("inverses");
        HashMap pinv = (HashMap)pmd.get("inverses");
        for (String key : inv.keySet()) {
            pinv.put(key, (String)inv.get(key));
        }
        HashMap invid = md.containsKey("inverseid") ? (HashMap)md.get("inverseid") : new HashMap(0);
        HashMap<String, Pair> pinvid = pmd.containsKey("inverseid") ? (HashMap<String, Pair>)pmd.get("inverseid") : new HashMap<String, Pair>(invid.size());
        for (String key : invid.keySet()) {
            pinvid.put(key, this.deepClone((Pair)invid.get(key)));
        }
    }

    @Override
    public void useStandardTransformer() {
        this.sqlAction.useStandardTransformer();
    }

    static {
        META_MAP = new HashMap();
        ENTITY_LIFT_MAP = new HashMap();
    }
}

