/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.mapper;

import com.af.v4.system.restful.config.SystemConfig;
import com.af.v4.system.restful.mapper.AbstractResourceMapper;
import com.af.v4.system.restful.mapper.ModuleMapper;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManagerFactory;
import org.dom4j.Element;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.springframework.stereotype.Component;

@Component
public class SqlMapper
extends AbstractResourceMapper<String> {
    public static final String DIALECT_SQLSERVER = "SqlServer";
    public static final String DIALECT_ORACLE = "Oracle";
    public static final String DIALECT_MYSQL = "MySQL";
    private static String dialectType;
    private final EntityManagerFactory entityManagerFactory;

    public SqlMapper(ModuleMapper moduleMapper, SystemConfig systemConfig, EntityManagerFactory entityManagerFactory) {
        super(moduleMapper, systemConfig);
        this.entityManagerFactory = entityManagerFactory;
    }

    @Override
    protected String getResType() {
        return "sql";
    }

    @Override
    protected String getFileName() {
        return "sql.xml";
    }

    @Override
    protected String getFolderName() {
        return "sqls";
    }

    @Override
    protected Map<String, String> appendRes(Element element, String moduleName, String parentModuleName) {
        Map<String, String> res = super.appendRes(element, moduleName, parentModuleName);
        String mobile = element.attributeValue("mobile");
        res.put("mobile", mobile);
        return res;
    }

    @Override
    public AbstractResourceMapper.CommonResource<String> getValue(String alias) {
        String dialect;
        Object newAlias = switch (dialect = this.getDialectType()) {
            case DIALECT_ORACLE -> alias + "_oracle";
            case DIALECT_MYSQL -> alias + "_mysql";
            default -> alias;
        };
        AbstractResourceMapper.CommonResource<String> commonResource = super.getValue((String)newAlias);
        if (commonResource.getPath() == null && !dialect.equals(DIALECT_SQLSERVER)) {
            commonResource = super.getValue(alias);
        }
        return commonResource;
    }

    public String getDialectType() {
        return dialectType;
    }

    @PostConstruct
    public void init() {
        SessionFactoryImplementor sf = (SessionFactoryImplementor)this.entityManagerFactory.unwrap(SessionFactoryImplementor.class);
        String dialect = sf.getJdbcServices().getDialect().toString().toLowerCase();
        if (dialect.contains("sqlserver")) {
            dialectType = DIALECT_SQLSERVER;
        } else if (dialect.contains("oracle")) {
            dialectType = DIALECT_ORACLE;
        } else if (dialect.contains("mysql")) {
            dialectType = DIALECT_MYSQL;
        } else {
            throw new RuntimeException("\u6570\u636e\u5e93\u65b9\u8a00\u914d\u7f6e\u5f02\u5e38\u3002");
        }
    }
}

