/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.config;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.restful.sql.dynamic.MyDruidDataSource;
import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Configuration
@ConfigurationProperties(prefix="db")
@Component
public class DynamicDataSourceConfig {
    private List<MyDruidDataSource> dataSourceList;
    private List<String> subClass;
    private Integer initialSize;
    private Integer minIdle;
    private Integer maxActive;
    private Integer maxWait;
    private Integer connectTimeout;
    private Integer socketTimeout;

    @Bean
    @Primary
    public DynamicDataSource routingDataSource() {
        HashMap targetDataSources = new HashMap(this.dataSourceList.size());
        this.dataSourceList.forEach(item -> {
            this.setProperties((DruidDataSource)item);
            targetDataSources.put(item.getName(), item);
        });
        return new DynamicDataSource((DataSource)((Object)this.dataSourceList.get(0)), targetDataSources);
    }

    private void setProperties(DruidDataSource item) {
        Properties connectProperties = new Properties();
        item.setInitialSize(Objects.requireNonNullElse(this.initialSize, 3).intValue());
        item.setMinIdle(Objects.requireNonNullElse(this.minIdle, 3).intValue());
        item.setMaxActive(Objects.requireNonNullElse(this.maxActive, 8).intValue());
        item.setMaxWait((long)Objects.requireNonNullElse(this.maxWait, 60000).intValue());
        item.setConnectTimeout(Objects.requireNonNullElse(this.connectTimeout, 10000).intValue());
        item.setSocketTimeout(Objects.requireNonNullElse(this.socketTimeout, 30000).intValue());
        item.setTimeBetweenEvictionRunsMillis(60000L);
        item.setMinEvictableIdleTimeMillis(180000L);
        item.setTestWhileIdle(true);
        item.setTestOnBorrow(false);
        item.setTestOnReturn(false);
        item.setUseUnfairLock(true);
        String driverClassName = item.getDriverClassName();
        if (driverClassName.contains("SQLServer") || driverClassName.contains("Oracle")) {
            item.setPoolPreparedStatements(true);
            item.setMaxPoolPreparedStatementPerConnectionSize(20);
            if (driverClassName.contains("SQLServer")) {
                item.setValidationQuery("select 1");
            } else {
                connectProperties.setProperty("oracle.net.CONNECT_TIMEOUT", String.valueOf(item.getConnectTimeout()));
                connectProperties.setProperty("oracle.jdbc.ReadTimeout", String.valueOf(item.getSocketTimeout()));
            }
        }
        if (Objects.equals(item.getValidationQuery(), DruidAbstractDataSource.DEFAULT_VALIDATION_QUERY)) {
            item.setValidationQuery("select 1 from dual");
        }
        try {
            item.setFilters("stat,slf4j");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        connectProperties.setProperty("druid.stat.mergeSql", "true");
        connectProperties.setProperty("druid.stat.slowSqlMilli", "5000");
        item.setConnectProperties(connectProperties);
    }

    public List<MyDruidDataSource> getDataSourceList() {
        return this.dataSourceList;
    }

    public void setDataSourceList(List<MyDruidDataSource> dataSourceList) {
        this.dataSourceList = dataSourceList;
    }

    public Integer getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(Integer initialSize) {
        this.initialSize = initialSize;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public Integer getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(Integer maxActive) {
        this.maxActive = maxActive;
    }

    public Integer getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(Integer maxWait) {
        this.maxWait = maxWait;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public List<String> getSubClass() {
        return this.subClass;
    }

    public void setSubClass(List<String> subClass) {
        this.subClass = subClass;
    }
}

