package com.af.v4.system.restful.transaction;

import com.af.v4.system.restful.sql.dynamic.DynamicSessionFactory;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.internal.SessionFactoryImpl;
import org.springframework.stereotype.Component;

/**
 * session池
 *
 * @author LocalUser
 */
@Component
public class SessionPool {
    private final DynamicSessionFactory dynamicSessionFactory;

    private SessionPool(DynamicSessionFactory dynamicSessionFactory) {
        this.dynamicSessionFactory = dynamicSessionFactory;
    }

    /**
     * 从sessionFactory中取
     *
     * @return session
     */
    public Session getSession() {
        SessionFactory factory = dynamicSessionFactory.getHibernateSessionFactory();
        return factory.getCurrentSession();
    }

    public SessionFactoryImpl getSessionFactory() {
        return dynamicSessionFactory.getHibernateSessionFactory().unwrap(SessionFactoryImpl.class);
    }
}
