package com.af.v4.system.restful.sql.dynamic;

import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.SessionFactoryUtils;

import javax.sql.DataSource;
import java.io.Serial;
import java.util.Objects;

/**
 * 动态数据源事务管理器
 */
public class DynamicTransactionManager extends HibernateTransactionManager {

    @Serial
    private static final long serialVersionUID = -4655721479296819154L;

    @Override
    public DataSource getDataSource() {
        return SessionFactoryUtils.getDataSource(Objects.requireNonNull(getSessionFactory()));
    }

    @Override
    public SessionFactory getSessionFactory() {
        DynamicSessionFactory dynamicSessionFactory = (DynamicSessionFactory) super.getSessionFactory();
        assert dynamicSessionFactory != null;
        return dynamicSessionFactory.getHibernateSessionFactory();
    }
}
