package com.af.v4.system.restful.sql;

import cn.hutool.core.date.DateUtil;
import com.af.v4.system.restful.utils.ClobUtil;
import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;

import java.io.Serial;
import java.math.BigDecimal;
import java.sql.Clob;
import java.util.Date;

public class AliasTransformer extends AliasedTupleSubsetResultTransformer {

    public static final AliasTransformer INSTANCE = new AliasTransformer();

    /**
     * Disallow instantiation of AliasToEntityMapResultTransformer.
     */
    private AliasTransformer() {
    }

    @Override
    public JSONObject transformTuple(Object[] tuple, String[] aliases) {
        JSONObject result = new JSONObject();
        for (int i = 0; i < aliases.length; i++) {
            String alias = aliases[i];
            Object value = tuple[i];
            if (alias != null) {
                if (value == null){
                    value = JSONObject.NULL;
                } else if (value instanceof BigDecimal bigDecimal) {
                    if (isIntegerValue(bigDecimal)) {
                        long longValue = bigDecimal.longValue();
                        if(longValue < Integer.MAX_VALUE){
                            value = (int) longValue;
                        } else {
                            value = longValue;
                        }
                    }
                } else if(value instanceof Date date){
                    // 处理日期格式
                    value = DateUtil.formatDateTime(date);
                } else if(value instanceof Clob clob){
                    value = ClobUtil.getClobString(clob);
                }
                result.put(alias.toLowerCase(), value);
            }
        }
        return result;
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        return bd.stripTrailingZeros().scale() <= 0;
    }

    @Override
    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    /**
     * Serialization hook for ensuring singleton unique.
     *
     * @return The singleton instance : {@link #INSTANCE}
     */
    @Serial
    private Object readResolve() {
        return INSTANCE;
    }
}
