package com.af.v4.system.restful.enums.queryparams;

import java.util.stream.Stream;

/**
 * 表格列固定类型
 *
 * @author Mr.river
 */
public enum ColumnFixedTypeEnum {
    LEFT("left"),
    RIGHT("right");

    private final String value;

    ColumnFixedTypeEnum(String value) {
        this.value = value;
    }

    public static ColumnFixedTypeEnum toType(String value) {
        return Stream.of(ColumnFixedTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
