package com.af.v4.system.restful.enums.entity;

import java.util.stream.Stream;

/**
 * 方言类型
 */
public enum DialectTypeEnum {
    DIALECT_SQLSERVER("sqlserver"),
    DIALECT_ORACLE("oracle"),
    DIALECT_MYSQL("mysql"),
    DIALECT_DM("dm"),
    DIALECT_NOT_SUPPORTED("NoSupported");

    private final String value;

    DialectTypeEnum(String value) {
        this.value = value;
    }

    public static DialectTypeEnum toType(String value) {
        return Stream.of(DialectTypeEnum.values())
                .filter(p -> value.contains(p.value))
                .findAny()
                .orElse(DIALECT_NOT_SUPPORTED);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
