package com.af.v4.system.restful.config;

import com.af.v4.system.restful.dialect.MyDialectResolver;
import com.af.v4.system.restful.sql.dynamic.DynamicDataSource;
import com.af.v4.system.restful.sql.dynamic.DynamicSessionFactory;
import com.af.v4.system.restful.sql.dynamic.DynamicSessionFactoryImpl;
import com.af.v4.system.restful.sql.dynamic.DynamicTransactionManager;
import com.alibaba.druid.pool.DruidDataSource;
import org.hibernate.SessionFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

@Configuration
@ConfigurationProperties(prefix = "spring.datasource")
public class HibernateConfig {

    public final String currentSessionContextClass = "org.springframework.orm.hibernate5.SpringSessionContext";
    private final ApplicationContext context;

    public HibernateConfig(ApplicationContext context) {
        this.context = context;
    }

    @Bean
    public DynamicSessionFactory dynamicSessionFactory(){
        Map<String, DruidDataSource> dataSourceList = DynamicDataSource.getDataSourceList();
        Map<Object, LocalSessionFactoryBean> sessionFactoryBeanMap = new HashMap<>(dataSourceList.size());
        dataSourceList.forEach((key,value) -> {
            LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
            sessionFactoryBean.setDataSource(value);
            // entity的公共包
            if(key.equals("master")){
                sessionFactoryBean.setPackagesToScan("com.af.v4.entity");
            } else {
                sessionFactoryBean.setPackagesToScan("com.af.v4.entity." + key);
            }
            Properties properties = new Properties();
            properties.setProperty("hibernate.hbm2ddl.auto", "update");
            properties.setProperty("hibernate.show_sql", "false");
            properties.setProperty("hibernate.format_sql", "false");
            properties.setProperty("hibernate.current_session_context_class", currentSessionContextClass);
            // 方言解析器配置
            properties.setProperty("hibernate.dialect_resolvers", MyDialectResolver.class.getCanonicalName());
            sessionFactoryBean.setHibernateProperties(properties);
            // configLocations
            JSONObject cfgLocations = SystemConfig.Hibernate.getCfgLocations();
            if(cfgLocations.has(key)) {
                JSONArray locations = cfgLocations.getJSONArray(key);
                // 加入基础配置
                locations.put("classpath:/entity/Base/hibernate.cfg.xml");
                Resource[] cfgLocationResources = locations.toList().stream()
                        .map(item -> context.getResource((String) item)).toList()
                        .toArray(new Resource[cfgLocations.length()]);
                sessionFactoryBean.setConfigLocations(cfgLocationResources);
            }
            try {
                sessionFactoryBean.afterPropertiesSet();
            } catch (IOException e) {
                throw new RuntimeException(e);
            }
            sessionFactoryBeanMap.put(key, sessionFactoryBean);
        });
        return new DynamicSessionFactoryImpl(sessionFactoryBeanMap, sessionFactoryBeanMap.get("master"));
    }

    @Bean
    public DynamicTransactionManager transactionManager() {
        DynamicTransactionManager transactionManager = new DynamicTransactionManager();
        // 注入sessionFactory
        transactionManager.setSessionFactory(dynamicSessionFactory());
        return transactionManager;
    }
}
