package com.af.v4.system.restful.enums.file;

import java.util.stream.Stream;

/**
 * 资源上传模式
 * @author Mr.river
 */
public enum ResUploadModeEnum {
    /**
     * 服务器
     */
    SERVER("server"),
    /**
     * 对象存储
     */
    OSS("oss"),
    /**
     * Base64
     */
    BASE64("base64");


    private final String value;

    ResUploadModeEnum(String value) {
        this.value = value;
    }

    public static ResUploadModeEnum toType(String value) {
        return Stream.of(ResUploadModeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public String getValue(){
        return value;
    }
}
