package com.af.v4.system.restful.sql;

import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;

import java.io.Serial;
import java.math.BigDecimal;

public class AliasTransformer extends AliasedTupleSubsetResultTransformer {

    public static final AliasTransformer INSTANCE = new AliasTransformer();

    /**
     * Disallow instantiation of AliasToEntityMapResultTransformer.
     */
    private AliasTransformer() {
    }

    @Override
    public JSONObject transformTuple(Object[] tuple, String[] aliases) {
        JSONObject result = new JSONObject();
        for (int i = 0; i < tuple.length; i++) {
            String alias = aliases[i];
            Object value = tuple[i];
            if (alias != null) {
                String key = alias.toLowerCase();
                // 处理bigDecimal
                if (value instanceof BigDecimal bigDecimal) {
                    if (isIntegerValue(bigDecimal)) {
                        long longValue = bigDecimal.longValue();
                        if(longValue < Integer.MAX_VALUE){
                            result.put(key, (int) longValue);
                        } else {
                            result.put(key, longValue);
                        }
                        continue;
                    }
                }
                result.put(alias.toLowerCase(), tuple[i]);
            }
        }
        return result;
    }

    private static boolean isIntegerValue(BigDecimal bd) {
        return bd.stripTrailingZeros().scale() <= 0;
    }

    @Override
    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    /**
     * Serialization hook for ensuring singleton unique.
     *
     * @return The singleton instance : {@link #INSTANCE}
     */
    @Serial
    private Object readResolve() {
        return INSTANCE;
    }
}
