package com.af.v4.system.restful.mapper;

import com.af.v4.system.restful.config.SystemConfig;
import org.checkerframework.checker.units.qual.A;
import org.dom4j.Element;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.persistence.EntityManagerFactory;
import java.util.Map;

/**
 * SQL映射器
 *
 * @author Mr.river
 */
@Component
public class SqlMapper extends AbstractResourceMapper<String> {

    public static final String DIALECT_SQLSERVER = "SqlServer";
    public static final String DIALECT_ORACLE = "Oracle";
    public static final String DIALECT_MYSQL = "MySQL";
    /**
     * 方言类型
     */
    private static String dialectType;
    private final EntityManagerFactory entityManagerFactory;

    public SqlMapper(ModuleMapper moduleMapper, SystemConfig systemConfig, EntityManagerFactory entityManagerFactory) {
        super(moduleMapper, systemConfig);
        this.entityManagerFactory = entityManagerFactory;
    }


    @Override
    protected String getResType() {
        return "sql";
    }

    @Override
    protected String getFileName() {
        return "sql.xml";
    }

    @Override
    protected String getFolderName() {
        return "sqls";
    }

    @Override
    protected Map<String, String> appendRes(Element element, String moduleName, String parentModuleName) {
        Map<String, String> res = super.appendRes(element, moduleName, parentModuleName);
        // 追加元素
        String mobile = element.attributeValue("mobile");
        res.put("mobile", mobile);
        return res;
    }

    @Override
    public CommonResource<String> getValue(String alias) {
        String dialect = getDialectType();
        String newAlias = switch (dialect) {
            case SqlMapper.DIALECT_ORACLE -> alias + "_oracle";
            case SqlMapper.DIALECT_MYSQL -> alias + "_mysql";
            default -> alias;
        };
        CommonResource<String> commonResource = super.getValue(newAlias);
        if(commonResource == null && !dialect.equals(SqlMapper.DIALECT_SQLSERVER)){
            commonResource = super.getValue(alias);
        }
        return commonResource;
    }

    public String getDialectType() {
        return dialectType;
    }


    @PostConstruct
    public void init() {
        SessionFactoryImplementor sf = entityManagerFactory.unwrap(SessionFactoryImplementor.class);
        String dialect = sf.getJdbcServices().getDialect().toString().toLowerCase();
        if (dialect.contains("sqlserver")) {
            dialectType = SqlMapper.DIALECT_SQLSERVER;
        } else if (dialect.contains("oracle")) {
            dialectType = SqlMapper.DIALECT_ORACLE;
        } else if (dialect.contains("mysql")) {
            dialectType = SqlMapper.DIALECT_MYSQL;
        } else {
            throw new RuntimeException("数据库方言配置异常。");
        }
    }
}
