/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.sql.dynamic;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class DynamicDataSource
extends AbstractRoutingDataSource {
    private static final ThreadLocal<String> contextHolder = new ThreadLocal();
    private static final Map<String, DruidDataSource> dataSourceInfo = new HashMap<String, DruidDataSource>(3);

    public DynamicDataSource(DataSource defaultTargetDataSource, Map<Object, Object> targetDataSources) {
        for (Map.Entry<Object, Object> item : targetDataSources.entrySet()) {
            dataSourceInfo.put((String)item.getKey(), (DruidDataSource)item.getValue());
        }
        super.setDefaultTargetDataSource((Object)defaultTargetDataSource);
        super.setTargetDataSources(targetDataSources);
        super.afterPropertiesSet();
    }

    public static String getDataSource() {
        String source = contextHolder.get();
        if (source == null) {
            return "master";
        }
        return source;
    }

    public static void setDataSource(String dataSource) {
        contextHolder.set(dataSource);
    }

    public static void clearDataSource() {
        contextHolder.remove();
    }

    protected Object determineCurrentLookupKey() {
        return DynamicDataSource.getDataSource();
    }

    public static Map<String, DruidDataSource> getDataSourceList() {
        return dataSourceInfo;
    }

    public static DruidDataSource getDruidDataSource() {
        return DynamicDataSource.getDataSourceList().get(DynamicDataSource.getDataSource());
    }
}

