/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.service;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.expression.Expression;
import com.af.v4.system.restful.exception.FileNotFoundException;
import com.af.v4.system.restful.mapper.ResourceMapper;
import com.af.v4.system.restful.mapper.SqlMapper;
import com.af.v4.system.restful.sql.SqlAction;
import com.af.v4.system.restful.utils.enums.ResourceType;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SqlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlService.class);
    private final ResourceMapper resourceMapper;
    private final SqlMapper sqlMapper;
    private final SqlAction sqlAction;

    public SqlService(ResourceMapper resourceMapper, SqlMapper sqlMapper, SqlAction sqlAction) {
        this.resourceMapper = resourceMapper;
        this.sqlMapper = sqlMapper;
        this.sqlAction = sqlAction;
    }

    public String getSQL(String name, JSONObject params) {
        return this.call(name, params);
    }

    public JSONObject queryTotal(String name, JSONObject params) {
        Object sums = null;
        if (params.has("sums")) {
            sums = params.get("sums");
        }
        String sql = this.call(name, params);
        sql = this.filterOutOrderBy(sql, sums);
        JSONArray array = this.sqlAction.query(name, sql);
        return array.getJSONObject(0);
    }

    public JSONObject queryTotal(String name, String str) {
        JSONObject param;
        Object sums = null;
        if (str != null && !str.isEmpty()) {
            JSONObject json = new JSONObject(str);
            param = json.has("data") ? json.getJSONObject("data") : new JSONObject();
            if (json.has("sums")) {
                sums = json.get("sums");
            }
        } else {
            param = new JSONObject();
        }
        String sql = this.call(name, param);
        sql = this.filterOutOrderBy(sql, sums);
        JSONArray array = this.sqlAction.query(name, sql);
        return array.getJSONObject(0);
    }

    public JSONArray query(String name, JSONObject params, Integer pageNo, Integer pageSize) {
        String sql = this.call(name, params);
        JSONArray array = this.sqlAction.query(name, sql, pageNo - 1, pageSize);
        LOGGER.info("SQL[" + name + "] Result: \n" + array.toString());
        return array;
    }

    public JSONArray query(String name, JSONObject params, Integer pageSize) {
        return pageSize <= 0 ? this.query(name, params, (Integer)1, (Integer)9999999) : this.query(name, params, (Integer)1, pageSize);
    }

    public JSONArray query(String name, JSONObject params) {
        return this.query(name, params, (Integer)1, (Integer)1000);
    }

    public JSONArray query(String name, String str, Integer pageNo, Integer pageSize) {
        JSONObject param;
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 9999999;
        }
        if (str != null && !str.isEmpty()) {
            param = new JSONObject(str);
            param = param.getJSONObject("data");
        } else {
            param = new JSONObject();
        }
        return this.query(name, param, pageNo, pageSize);
    }

    public JSONArray query(String name, String str, Integer pageSize) {
        return pageSize <= 0 ? this.query(name, str, (Integer)1, (Integer)9999999) : this.query(name, str, (Integer)1, pageSize);
    }

    public JSONArray query(String name, String str) {
        return this.query(name, str, (Integer)1, (Integer)1000);
    }

    public JSONArray querySQL(String name, String sql) {
        return this.querySQL(name, sql, 1, 1000);
    }

    public JSONArray querySQL(String name, String sql, Integer pageSize) {
        return pageSize <= 0 ? this.querySQL(name, sql, 1, 9999999) : this.querySQL(name, sql, 1, pageSize);
    }

    public JSONArray querySQL(String name, String sql, int pageNo, int pageSize) {
        JSONArray array = this.sqlAction.query(name, sql, pageNo - 1, pageSize);
        LOGGER.info("SQL[" + name + "] Result: \n" + array.toString());
        return array;
    }

    public Integer update(String name, JSONObject params) {
        String sql = this.call(name, params);
        return this.updateSQL(name, sql);
    }

    public Integer updateSQL(String name, String sql) {
        return this.sqlAction.bulkSQLUpdate(name, sql);
    }

    public String call(String sqlName, JSONObject json) {
        String sql;
        String path = this.sqlMapper.getValue(sqlName);
        if (path == null) {
            throw new ServiceException("sql\u8bed\u53e5\u672a\u6ce8\u518c\uff01" + sqlName);
        }
        try {
            sql = this.resourceMapper.getString(ResourceType.SQL, sqlName, path);
            if (sql.contains("${")) {
                sql = sql.replace("${", "{");
            }
        }
        catch (FileNotFoundException e) {
            throw new ServiceException(path + ".\u6587\u4ef6\u65e0\u914d\u7f6e");
        }
        json.put("sql", (Object)this);
        sql = Expression.run((String)sql, (Map)json.toMap()).toString();
        return sql;
    }

    private String filterOutOrderBy(String source, Object sums) {
        int idx = source.toLowerCase().lastIndexOf("order by");
        if (idx == -1) {
            idx = source.length() - 1;
        }
        StringBuilder sql = new StringBuilder("select ");
        if (sums != null) {
            if (sums instanceof JSONArray) {
                JSONArray arraySums = (JSONArray)sums;
                for (int i = 0; i < arraySums.length(); ++i) {
                    String name = (String)arraySums.get(i);
                    sql.append("sum(").append(name).append(") ").append(name).append(", ");
                }
            } else if (sums instanceof JSONObject) {
                JSONObject objSums = (JSONObject)sums;
                Iterator keys = objSums.keys();
                while (keys.hasNext()) {
                    String name = (String)keys.next();
                    String value = objSums.getString(name);
                    sql.append("sum(").append(value).append(") ").append(name).append(", ");
                }
            }
        }
        if (idx != -1) {
            sql.append("count(*) n, 1 placeholder from ( ").append(source, 0, idx).append(") t_");
        }
        return sql.toString();
    }
}

