/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.service;

import com.af.v4.system.api.RemoteEntityService;
import com.af.v4.system.common.core.domain.R;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LocalEntityService {
    private final RemoteEntityService entityService;
    private final Logger LOGGER = LoggerFactory.getLogger(LocalEntityService.class);

    public LocalEntityService(RemoteEntityService entityService) {
        this.entityService = entityService;
    }

    public JSONObject partialSave(String entityName, JSONObject entity) {
        R entityResult = this.entityService.save(entityName, entity.toString(), "inner");
        return entityResult.parseResponseJson();
    }

    public JSONObject batchSave(String entityName, JSONObject entity) {
        R entityResult = this.entityService.saveBatch(entityName, entity.toString(), "inner");
        return entityResult.parseResponseJson();
    }

    public JSONObject deleteById(String entityName, Object id) {
        R entityResult = this.entityService.deleteById(entityName, String.valueOf(id), "inner");
        return entityResult.parseResponseJson();
    }

    public JSONObject deleteAllByIds(String entityName, JSONArray ids) {
        JSONObject content = new JSONObject();
        content.put("ids", (Object)ids);
        R entityResult = this.entityService.deleteAllByIds(entityName, content.toString(), "inner");
        return entityResult.parseResponseJson();
    }

    public JSONObject getById(String entityName, Object id) {
        return this.getById(null, entityName, id);
    }

    public JSONObject getById(String columns, String entityName, Object id) {
        JSONObject content = new JSONObject();
        if (columns != null) {
            content.put("columns", (Object)columns);
        }
        R entityResult = this.entityService.getById(entityName, String.valueOf(id), content.toString(), "inner");
        return entityResult.parseResponseJson();
    }

    public JSONObject findAllByIds(String entityName, JSONArray ids) {
        return this.findAllByIds(null, entityName, ids);
    }

    public JSONObject findAllByIds(String columns, String entityName, JSONArray ids) {
        JSONObject content = new JSONObject();
        content.put("ids", (Object)ids);
        if (columns != null) {
            content.put("columns", (Object)columns);
        }
        R entityResult = this.entityService.findAllByIds(entityName, content.toString(), "inner");
        return entityResult.parseResponseJson();
    }
}

