/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.mapper;

import com.af.v4.system.restful.mapper.AbstractResourceMapper;
import com.af.v4.system.restful.mapper.ModuleMapper;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManagerFactory;
import org.dom4j.Element;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.springframework.stereotype.Component;

@Component
public class SqlMapper
extends AbstractResourceMapper<String> {
    public static final String DIALECT_SQLSERVER = "SqlServer";
    public static final String DIALECT_ORACLE = "Oracle";
    public static final String DIALECT_MYSQL = "MySQL";
    private static String dialectType;
    private final EntityManagerFactory entityManagerFactory;

    public SqlMapper(ModuleMapper moduleMapper, EntityManagerFactory entityManagerFactory) {
        super(moduleMapper);
        this.entityManagerFactory = entityManagerFactory;
    }

    @Override
    protected String getResType() {
        return "sql";
    }

    @Override
    protected String getFileName() {
        return "sql.xml";
    }

    @Override
    protected String getFolderName() {
        return "sqls";
    }

    @Override
    protected Map<String, String> appendRes(Element element, String moduleName, String parentModuleName) {
        Map<String, String> res = super.appendRes(element, moduleName, parentModuleName);
        String mobile = element.attributeValue("mobile");
        res.put("mobile", mobile);
        return res;
    }

    @Override
    public String getValue(String alias) {
        String dialect;
        Object newAlias = switch (dialect = this.getDialectType()) {
            case DIALECT_ORACLE -> alias + "_oracle";
            case DIALECT_MYSQL -> alias + "_mysql";
            default -> alias;
        };
        String value = (String)super.getValue((String)newAlias);
        if (value == null && !dialect.equals(DIALECT_SQLSERVER)) {
            value = (String)super.getValue(alias);
        }
        return value;
    }

    public String getDialectType() {
        return dialectType;
    }

    @PostConstruct
    public void init() throws Exception {
        SessionFactoryImplementor sf = (SessionFactoryImplementor)this.entityManagerFactory.unwrap(SessionFactoryImplementor.class);
        String dialect = sf.getJdbcServices().getDialect().toString().toLowerCase();
        if (dialect.contains("sqlserver")) {
            dialectType = DIALECT_SQLSERVER;
        } else if (dialect.contains("oracle")) {
            dialectType = DIALECT_ORACLE;
        } else if (dialect.contains("mysql")) {
            dialectType = DIALECT_MYSQL;
        } else {
            throw new Exception("\u6570\u636e\u5e93\u65b9\u8a00\u914d\u7f6e\u5f02\u5e38\u3002");
        }
    }
}

