/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.config;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.plugins.io.IOTools;
import com.af.v4.system.plugins.json.JsonTools;
import com.af.v4.system.restful.dialect.MySqlServerDialect;
import com.af.v4.system.restful.exception.FileNotFoundException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SystemConfig {
    public static final String CONFIG_PATH = "systemConfig.json";
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemConfig.class);
    private static boolean isLoaded = false;

    private SystemConfig() {
    }

    private static void load() {
        if (!isLoaded) {
            JSONObject hibernate;
            isLoaded = true;
            if (!IOTools.hasResource((String)CONFIG_PATH)) {
                throw new FileNotFoundException("\u7cfb\u7edf\u914d\u7f6e\u6587\u4ef6systemConfig.json\u4e0d\u5b58\u5728", CONFIG_PATH);
            }
            JSONObject params = JsonTools.readJsonFile((String)CONFIG_PATH);
            JSONObject system = params.getJSONObject("system");
            if (!system.has("webAppName")) {
                throw new ServiceException("systemConfig.json\u4e2d\u670d\u52a1\u5e94\u7528\u6a21\u5757\u540d\u53c2\u6570[system:webAppName]\u4e0d\u5b58\u5728\uff0c\u8bf7\u914d\u7f6e\u8be5\u53c2\u6570\u4e3aweb\u5e94\u7528\u540d\u79f0\uff0c\u5982revenue,webmeter\u7b49");
            }
            System.webAppName = system.getString("webAppName");
            JSONObject resources = params.getJSONObject("resources");
            if (!resources.has("fileRootPath")) {
                LOGGER.warn("systemConfig.json\u4e2d\u8d44\u6e90\u6839\u76ee\u5f55\u53c2\u6570[resources:fileRootPath]\u4e0d\u5b58\u5728\uff0c\u4ee5\u6309\u7167\u7f3a\u7701\u503c[C:/" + System.webAppName + "Res]\u914d\u7f6e");
            }
            Resources.fileRootPath = resources.optString("fileRootPath", "C:/" + System.webAppName + "Res");
            if (resources.has("extraPaths")) {
                Resources.extraPaths = resources.getJSONObject("extraPaths");
            }
            if (!(hibernate = params.getJSONObject("hibernate")).has("cfgLocations")) {
                throw new ServiceException("systemConfig.json\u4e2dHibernate\u5b9e\u4f53\u914d\u7f6e\u53c2\u6570[hibernate:cfgLocations]\u4e0d\u5b58\u5728");
            }
            Hibernate.dialect = hibernate.optString("dialect", MySqlServerDialect.class.getCanonicalName());
            Hibernate.cfgLocations = hibernate.getJSONObject("cfgLocations");
            Hibernate.subClassArray = hibernate.getJSONArray("subclass");
        }
    }

    public static class System {
        private static String webAppName;

        public static String getWebAppName() {
            return webAppName;
        }

        static {
            SystemConfig.load();
        }
    }

    public static class Resources {
        private static String fileRootPath;
        private static JSONObject extraPaths;

        public static String getFileRootPath() {
            return fileRootPath;
        }

        public static String getExtraPath(String key) {
            return extraPaths.getString(key);
        }

        static {
            SystemConfig.load();
        }
    }

    public static class Hibernate {
        private static String dialect;
        private static JSONObject cfgLocations;
        private static JSONArray subClassArray;

        public static String getDialect() {
            return dialect;
        }

        public static JSONObject getCfgLocations() {
            return cfgLocations;
        }

        public static JSONArray getSubClassArray() {
            return subClassArray;
        }

        public static boolean hasSubClassArray() {
            return subClassArray != null;
        }

        static {
            SystemConfig.load();
        }
    }
}

