/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.config;

import com.af.v4.system.restful.sql.dynamic.DynamicDataSource;
import com.alibaba.druid.pool.DruidAbstractDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Configuration
@ConfigurationProperties(prefix="db")
@Component
public class DynamicDataSourceConfig {
    private List<DruidDataSource> dataSourceList;
    private Integer initialSize;
    private Integer minIdle;
    private Integer maxActive;
    private Integer maxWait;

    @Bean
    @Primary
    public DynamicDataSource routingDataSource() {
        HashMap<Object, Object> targetDataSources = new HashMap<Object, Object>(this.dataSourceList.size());
        this.dataSourceList.forEach(item -> {
            this.setProperties((DruidDataSource)item);
            targetDataSources.put(item.getName(), item);
        });
        return new DynamicDataSource((DataSource)this.dataSourceList.get(0), targetDataSources);
    }

    private void setProperties(DruidDataSource item) {
        if (item.getInitialSize() == 0) {
            item.setInitialSize(Objects.requireNonNullElse(this.initialSize, 5).intValue());
        }
        if (item.getMinIdle() == 0) {
            item.setMinIdle(Objects.requireNonNullElse(this.minIdle, 5).intValue());
        }
        if (item.getMaxActive() == 8) {
            item.setMaxActive(Objects.requireNonNullElse(this.maxActive, 64).intValue());
        }
        if (item.getMaxWait() == -1L) {
            item.setMaxWait((long)Objects.requireNonNullElse(this.maxWait, 60000).intValue());
        }
        item.setTimeBetweenEvictionRunsMillis(60000L);
        item.setMinEvictableIdleTimeMillis(1800000L);
        item.setTestWhileIdle(true);
        item.setTestOnBorrow(false);
        item.setTestOnReturn(false);
        item.setUseUnfairLock(true);
        String driverClassName = item.getDriverClassName();
        if (driverClassName.contains("SQLServer") || driverClassName.contains("Oracle")) {
            item.setPoolPreparedStatements(true);
            item.setMaxPoolPreparedStatementPerConnectionSize(20);
            if (driverClassName.contains("SQLServer")) {
                item.setValidationQuery("select 1");
            }
        }
        if (Objects.equals(item.getValidationQuery(), DruidAbstractDataSource.DEFAULT_VALIDATION_QUERY)) {
            item.setValidationQuery("select 1 from dual");
        }
        try {
            item.setFilters("stat,slf4j");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        Properties properties = new Properties();
        properties.setProperty("druid.stat.mergeSql", "true");
        properties.setProperty("druid.stat.slowSqlMilli", "5000");
        item.setConnectProperties(properties);
    }

    public List<DruidDataSource> getDataSourceList() {
        return this.dataSourceList;
    }

    public void setDataSourceList(List<DruidDataSource> dataSourceList) {
        this.dataSourceList = dataSourceList;
    }

    public Integer getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(Integer initialSize) {
        this.initialSize = initialSize;
    }

    public Integer getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(Integer minIdle) {
        this.minIdle = minIdle;
    }

    public Integer getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(Integer maxActive) {
        this.maxActive = maxActive;
    }

    public Integer getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(Integer maxWait) {
        this.maxWait = maxWait;
    }
}

