/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.controller;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.resource.mapper.ResourceMapper;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/logic"})
public class LogicController {
    private final LogicService logicService;

    public LogicController(LogicService logicService) {
        this.logicService = logicService;
    }

    @Log(title="\u8c03\u7528Logic(GET)", businessType=BusinessType.LOGIC)
    @GetMapping(value={"{logicName}"}, produces={"application/json"})
    public R<Object> runGet(@PathVariable(value="logicName") String logicName, HttpServletResponse response, HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        JSONObject params = new JSONObject(parameterMap);
        String values = params.toString();
        return this.runMain(logicName, values, response);
    }

    @Log(title="\u8c03\u7528Logic", businessType=BusinessType.LOGIC)
    @PostMapping(value={"{logicName}"}, produces={"application/json"})
    public R<Object> run(@PathVariable(value="logicName") String logicName, @RequestBody String values, HttpServletResponse response, HttpServletRequest request) {
        values = this.getValues(values, request);
        return this.runMain(logicName, values, response);
    }

    @Log(title="\u6e05\u7406\u6240\u6709\u7f13\u5b58", businessType=BusinessType.CLEAR_CACHE)
    @GetMapping(value={"/clearall"}, produces={"application/json"})
    public R<String> clearAllCache() {
        ResourceMapper.clearLogicCache();
        ResourceMapper.clearSqlCache();
        return R.ok((Object)"ok");
    }

    private String getValues(String values, HttpServletRequest request) {
        if (!values.startsWith("{")) {
            JSONObject paramJson = new JSONObject();
            paramJson.put("str", (Object)values);
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                JSONObject header = new JSONObject();
                while (headerNames.hasMoreElements()) {
                    String temp = (String)headerNames.nextElement();
                    header.put(temp, (Object)request.getHeader(temp));
                }
                paramJson.put("header", (Object)header);
            }
            values = paramJson.toString();
        }
        return values;
    }

    private R<Object> runMain(String logicName, String values, HttpServletResponse response) {
        Map map;
        HashMap<String, String> result;
        JSONObject object;
        Object runResult = this.logicService.run(logicName, values);
        if (runResult instanceof JSONObject && (object = (JSONObject)runResult).has("header") && object.has("content")) {
            JSONObject paramHeader = object.getJSONObject("header");
            for (String key : paramHeader.keySet()) {
                response.setHeader(key, String.valueOf(paramHeader.get(key)));
            }
            runResult = object.get("content");
        }
        if (runResult instanceof JSONObject) {
            JSONObject json = (JSONObject)runResult;
            result = json.toMap();
        } else if (runResult instanceof JSONArray) {
            JSONArray array = (JSONArray)runResult;
            result = array.toList();
        } else if (runResult instanceof Map || runResult instanceof Collection) {
            result = runResult;
        } else {
            HashMap<String, String> objResult = new HashMap<String, String>(1);
            objResult.put("value", runResult.toString());
            result = objResult;
        }
        if (result instanceof Map && (map = (Map)result).containsKey("status")) {
            int status = (Integer)map.get("status");
            if (status == 200 && map.containsKey("data")) {
                return R.ok(map.get("data"));
            }
            if (status != 200 && map.containsKey("msg")) {
                return R.fail((int)status, (String)((String)map.get("msg")));
            }
        }
        return R.ok((Object)result);
    }
}

