/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.config;

import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.redis.RedisService;
import javax.annotation.PostConstruct;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class SystemConfig {
    private static final String CONFIG_TABLE_NAME = "t_system_params";
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemConfig.class);
    private final RedisService redisService;
    private final EntityService entityService;

    public SystemConfig(RedisService redisService, EntityService entityService) {
        this.redisService = redisService;
        this.entityService = entityService;
    }

    @PostConstruct
    public void init() {
        this.initSystemVersionAlias();
    }

    private void initSystemVersionAlias() {
        String versionAliasValue = (String)this.redisService.get("System@versionAlias");
        if (versionAliasValue == null) {
            this.redisService.lock("System@versionAlias_LOCK", () -> {
                String value = (String)this.redisService.get("System@versionAlias");
                if (value == null) {
                    JSONObject systemConfigContent;
                    String versionAliasColumnName = "f_version_alias";
                    JSONArray array = this.entityService.findAll(versionAliasColumnName, CONFIG_TABLE_NAME);
                    if (array.length() == 0) {
                        LOGGER.info("\u5f00\u59cb\u521d\u59cb\u5316\u7cfb\u7edf\u5b9a\u5236\u7248\u672c");
                        systemConfigContent = new JSONObject();
                        systemConfigContent.put(versionAliasColumnName, (Object)"standard");
                        try {
                            this.entityService.partialSave(CONFIG_TABLE_NAME, systemConfigContent);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        systemConfigContent = array.getJSONObject(0);
                    }
                    String alias = systemConfigContent.getString(versionAliasColumnName);
                    this.redisService.set("System@versionAlias", (Object)alias);
                    LOGGER.info("\u521d\u59cb\u5316\u7cfb\u7edf\u5b9a\u5236\u7248\u672c\u5b8c\u6210");
                } else {
                    LOGGER.info("\u7cfb\u7edf\u5b9a\u5236\u7248\u672c\u5df2\u914d\u7f6e\uff0c\u503c\u4e3a\uff1a" + value);
                }
            });
        } else {
            LOGGER.info("\u7cfb\u7edf\u5b9a\u5236\u7248\u672c\u5df2\u914d\u7f6e\uff0c\u503c\u4e3a\uff1a" + versionAliasValue);
        }
    }
}

