package com.af.v4.system.restful.config;

import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;

/**
 * 系统配置
 *
 * @author Mr.river
 */
@Component
public final class SystemConfig {
    private static final String CONFIG_TABLE_NAME = "t_system_params";
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemConfig.class);
    private final RedisService redisService;
    private final EntityService entityService;

    public SystemConfig(RedisService redisService, EntityService entityService) {
        this.redisService = redisService;
        this.entityService = entityService;
    }

    @PostConstruct
    public void init() {
        initSystemVersionAlias();
    }

    /**
     * 初始化系统版本别名
     */
    private void initSystemVersionAlias() {
        // 获取系统定制版本别名
        String versionAliasValue = redisService.get(AbstractResourceMapper.VERSION_ALIAS_KEY);
        if (versionAliasValue == null) {
            redisService.lock(AbstractResourceMapper.VERSION_ALIAS_KEY + "_LOCK", () -> {
                String value = redisService.get(AbstractResourceMapper.VERSION_ALIAS_KEY);
                if (value == null) {
                    //从数据库中查询并存储系统定制版本别名
                    String versionAliasColumnName = "f_version_alias";
                    JSONArray array = entityService.findAll(versionAliasColumnName, CONFIG_TABLE_NAME);
                    JSONObject systemConfigContent;
                    if (array.length() == 0) {
                        LOGGER.info("开始初始化系统定制版本");
                        systemConfigContent = new JSONObject();
                        systemConfigContent.put(versionAliasColumnName, AbstractResourceMapper.STANDARD_VERSION_VALUE);
                        try {
                            entityService.partialSave(CONFIG_TABLE_NAME, systemConfigContent);
                        } catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        systemConfigContent = array.getJSONObject(0);
                    }
                    String alias = systemConfigContent.getString(versionAliasColumnName);
                    redisService.set(AbstractResourceMapper.VERSION_ALIAS_KEY, alias);
                    LOGGER.info("初始化系统定制版本完成");
                } else {
                    LOGGER.info("系统定制版本已配置，值为：" + value);
                }
            });
        } else {
            LOGGER.info("系统定制版本已配置，值为：" + versionAliasValue);
        }
    }
}
