package com.af.v4.system.restful.controller;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.file.service.FileService;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * 文件控制器
 *
 * @author Mr.river
 */
@RestController
@RequestMapping("/resource")
public class FileController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileController.class);

    private final FileService fileService;

    public FileController(FileService fileService) {
        this.fileService = fileService;
    }

    /**
     * 资源上传
     * @param file 文件
     * @param resUploadMode 资源上传模式
     * @param stockId 文件仓库ID
     * @param operator 操作人
     * @param pathKey 扩展目录
     * @param formType 表单类型
     * @param useType 附件用途
     * @return 上传结果
     */
    @Log(title = "资源上传", businessType = BusinessType.OTHER)
    @PostMapping(value = "/upload", produces = MediaType.APPLICATION_JSON_VALUE)
    public R<Object> upload(
            @RequestParam("avatar") MultipartFile file,
            @RequestParam("resUploadMode") String resUploadMode,
            @RequestParam("resUploadStock") int stockId,
            @RequestParam("f_operator") String operator,
            @RequestParam("pathKey") String pathKey,
            @RequestParam("formType") String formType,
            @RequestParam("useType") String useType) {
        LOGGER.info("开始进行文件上传，文件名：" + file.getOriginalFilename());
        FileService.FileUploadResult result = fileService.uploadFile(file, resUploadMode, stockId, operator, pathKey, formType, useType);

        if (result.getSuccess()) {
            return R.ok(result);
        } else {
            return R.fail(result, result.getData().toString());
        }
    }
}
