/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.controller;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.common.resource.core.ResourceIndexer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/logic"})
public class LogicController {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogicController.class);
    private final LogicService logicService;
    private static final String RESPONSE_HEADER = "header";
    private static final String RESPONSE_CONTENT = "content";
    private static final String RESPONSE_VALUE = "value";

    public LogicController(LogicService logicService) {
        this.logicService = logicService;
    }

    @Log(title="\u8c03\u7528Logic", businessType=BusinessType.LOGIC)
    @RequestMapping(value={"{logicName}"}, produces={"application/json"})
    public R<Object> run(@PathVariable(value="logicName") String logicName, @RequestBody(required=false) String values, HttpServletResponse response, HttpServletRequest request) {
        String params = this.getRequestParams(values, request);
        return this.runMain(logicName, params, response);
    }

    @Log(title="\u5f02\u6b65\u8c03\u7528Logic", businessType=BusinessType.LOGIC)
    @RequestMapping(value={"/async/{logicName}"}, produces={"application/json"})
    public R<Object> runAsync(@PathVariable(value="logicName") String logicName, @RequestBody(required=false) String values, HttpServletRequest request) {
        String params = this.getRequestParams(values, request);
        this.logicService.runAsync(logicName, params).whenComplete((o, e) -> {
            if (o != null) {
                LOGGER.debug("\u5f02\u6b65\u8c03\u7528\u7ed3\u679c\uff1a{}", o);
            }
        });
        return R.ok((Object)"ok");
    }

    @Log(title="\u6e05\u7406\u6240\u6709\u7f13\u5b58", businessType=BusinessType.CLEAR_CACHE)
    @GetMapping(value={"/clearAll"}, produces={"application/json"})
    public R<String> clearAllCache() {
        ResourceIndexer.clearLogicCache();
        ResourceIndexer.clearSqlCache();
        return R.ok((Object)"ok");
    }

    private String getValues(String values, HttpServletRequest request) {
        if (!values.startsWith("{")) {
            JSONObject paramJson = new JSONObject();
            paramJson.put("str", (Object)values);
            Enumeration headerNames = request.getHeaderNames();
            if (headerNames != null) {
                JSONObject header = new JSONObject();
                while (headerNames.hasMoreElements()) {
                    String temp = (String)headerNames.nextElement();
                    header.put(temp, (Object)request.getHeader(temp));
                }
                paramJson.put(RESPONSE_HEADER, (Object)header);
            }
            values = paramJson.toString();
        }
        return values;
    }

    private String getRequestParams(String values, HttpServletRequest request) {
        String params;
        if (request.getMethod().equals(HttpMethod.GET.name()) && Optional.ofNullable(values).isEmpty()) {
            Map parameterMap = request.getParameterMap();
            JSONObject parameterMapObj = new JSONObject(parameterMap);
            params = parameterMapObj.toString();
        } else {
            params = this.getValues(values, request);
        }
        return params;
    }

    private R<Object> runMain(String logicName, String values, HttpServletResponse response) {
        Map map;
        HashMap<String, String> result;
        JSONObject object;
        Object runResult = this.logicService.run(logicName, values);
        if (runResult instanceof JSONObject && (object = (JSONObject)runResult).has(RESPONSE_HEADER) && object.has(RESPONSE_CONTENT)) {
            JSONObject paramHeader = object.getJSONObject(RESPONSE_HEADER);
            for (String key : paramHeader.keySet()) {
                response.setHeader(key, String.valueOf(paramHeader.get(key)));
            }
            runResult = object.get(RESPONSE_CONTENT);
        }
        if (runResult instanceof JSONObject) {
            JSONObject json = (JSONObject)runResult;
            result = json.toMap();
        } else if (runResult instanceof JSONArray) {
            JSONArray array = (JSONArray)runResult;
            result = array.toList();
        } else if (runResult instanceof Map || runResult instanceof Collection) {
            result = runResult;
        } else {
            HashMap<String, String> objResult = new HashMap<String, String>(1);
            objResult.put(RESPONSE_VALUE, runResult.toString());
            result = objResult;
        }
        if (result instanceof Map && (map = (Map)result).containsKey("status")) {
            int status = (Integer)map.get("status");
            if (status == 200 && map.containsKey("data")) {
                return R.ok(map.get("data"));
            }
            if (status != 200 && map.containsKey("msg")) {
                return R.fail((int)status, (String)((String)map.get("msg")));
            }
        }
        return R.ok((Object)result);
    }
}

