package com.af.v4.system.restful.sql.dynamic;

import org.hibernate.*;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.metadata.CollectionMetadata;
import org.hibernate.stat.Statistics;

import javax.naming.NamingException;
import javax.naming.Reference;
import javax.persistence.EntityGraph;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceUnitUtil;
import javax.persistence.SynchronizationType;
import javax.persistence.criteria.CriteriaBuilder;
import java.io.Serial;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 动态数据源Session工厂实现类
 */
public class DynamicSessionFactoryImpl implements DynamicSessionFactory {

    @Serial
    private static final long serialVersionUID = 5384069312247414885L;

    private final Map<Object, SessionFactory> targetSessionFactorys;
    private final SessionFactory defaultTargetSessionFactory;

    public DynamicSessionFactoryImpl(Map<Object, SessionFactory> targetSessionFactorys, SessionFactory defaultTargetSessionFactory) {
        this.targetSessionFactorys = targetSessionFactorys;
        this.defaultTargetSessionFactory = defaultTargetSessionFactory;
    }

    @Override
    public SessionFactory getHibernateSessionFactory() {
        SessionFactory targetSessionFactory = targetSessionFactorys.get(DynamicDataSource.getDataSource());
        if (targetSessionFactory != null) {
            return targetSessionFactory;
        } else {
            return defaultTargetSessionFactory;
        }
    }

    @Override
    public SessionFactoryOptions getSessionFactoryOptions() {
        return getHibernateSessionFactory().getSessionFactoryOptions();
    }

    @Override
    public SessionBuilder withOptions() {
        return getHibernateSessionFactory().withOptions();
    }

    @Override
    public Session openSession() throws HibernateException {
        return getHibernateSessionFactory().openSession();
    }

    @Override
    public Session getCurrentSession() throws HibernateException {
        return getHibernateSessionFactory().getCurrentSession();
    }

    @Override
    public StatelessSessionBuilder withStatelessOptions() {
        return getHibernateSessionFactory().withStatelessOptions();
    }

    @Override
    public StatelessSession openStatelessSession() {
        return getHibernateSessionFactory().openStatelessSession();
    }

    @Override
    public StatelessSession openStatelessSession(Connection connection) {
        return getHibernateSessionFactory().openStatelessSession(connection);
    }

    @Override
    public Statistics getStatistics() {
        return getHibernateSessionFactory().getStatistics();
    }

    @Override
    public void close() throws HibernateException {
        getHibernateSessionFactory().close();
    }

    @Override
    public Map<String, Object> getProperties() {
        return getHibernateSessionFactory().getProperties();
    }

    @Override
    public boolean isClosed() {
        return getHibernateSessionFactory().isClosed();
    }

    @Override
    public Cache getCache() {
        return getHibernateSessionFactory().getCache();
    }

    @Override
    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return getHibernateSessionFactory().getPersistenceUnitUtil();
    }

    @Override
    public void addNamedQuery(String name, javax.persistence.Query query) {
        getHibernateSessionFactory().addNamedQuery(name,query);
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        return getHibernateSessionFactory().unwrap(cls);
    }

    @Override
    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        getHibernateSessionFactory().addNamedEntityGraph(graphName, entityGraph);
    }

    @Override
    public Set getDefinedFilterNames() {
        return getHibernateSessionFactory().getDefinedFilterNames();
    }

    @Override
    public FilterDefinition getFilterDefinition(String filterName) throws HibernateException {
        return getHibernateSessionFactory().getFilterDefinition(filterName);
    }

    @Override
    public boolean containsFetchProfileDefinition(String name) {
        return getHibernateSessionFactory().containsFetchProfileDefinition(name);
    }

    @Override
    public TypeHelper getTypeHelper() {
        return getHibernateSessionFactory().getTypeHelper();
    }

    @Override
    public ClassMetadata getClassMetadata(Class entityClass) {
        return getHibernateSessionFactory().getClassMetadata(entityClass);
    }

    @Override
    public ClassMetadata getClassMetadata(String entityName) {
        return getHibernateSessionFactory().getClassMetadata(entityName);
    }

    @Override
    public CollectionMetadata getCollectionMetadata(String roleName) {
        return getHibernateSessionFactory().getCollectionMetadata(roleName);
    }

    @Override
    public Map<String, ClassMetadata> getAllClassMetadata() {
        return getHibernateSessionFactory().getAllClassMetadata();
    }

    @Override
    public Map getAllCollectionMetadata() {
        return getHibernateSessionFactory().getAllCollectionMetadata();
    }

    @Override
    public Reference getReference() throws NamingException {
        return getHibernateSessionFactory().getReference();
    }

    @Override
    public <T> List<EntityGraph<? super T>> findEntityGraphsByType(Class<T> entityClass) {
        return getHibernateSessionFactory().findEntityGraphsByType(entityClass);
    }

    @Override
    public EntityManager createEntityManager() {
        return getHibernateSessionFactory().createEntityManager();
    }

    @Override
    public EntityManager createEntityManager(Map map) {
        return getHibernateSessionFactory().createEntityManager(map);
    }

    @Override
    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return getHibernateSessionFactory().createEntityManager(synchronizationType);
    }

    @Override
    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        return getHibernateSessionFactory().createEntityManager(synchronizationType, map);
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        return getHibernateSessionFactory().getCriteriaBuilder();
    }

    @Override
    public Metamodel getMetamodel() {
        return getHibernateSessionFactory().getMetamodel();
    }

    @Override
    public boolean isOpen() {
        return getHibernateSessionFactory().isOpen();
    }
}
