package com.af.v4.system.restful.sql;

import org.hibernate.transform.AliasedTupleSubsetResultTransformer;
import org.json.JSONObject;

import java.io.Serial;

public class AliasTransformer extends AliasedTupleSubsetResultTransformer {

    public static final AliasTransformer INSTANCE = new AliasTransformer();

    /**
     * Disallow instantiation of AliasToEntityMapResultTransformer.
     */
    private AliasTransformer() {
    }

    @Override
    public JSONObject transformTuple(Object[] tuple, String[] aliases) {
        JSONObject result = new JSONObject(tuple.length);
        for (int i = 0; i < tuple.length; i++) {
            String alias = aliases[i];
            if (alias != null) {
                result.put(alias.toLowerCase(), tuple[i]);
            }
        }
        return result;
    }

    @Override
    public boolean isTransformedValueATupleElement(String[] aliases, int tupleLength) {
        return false;
    }

    /**
     * Serialization hook for ensuring singleton unique.
     *
     * @return The singleton instance : {@link #INSTANCE}
     */
    @Serial
    private Object readResolve() {
        return INSTANCE;
    }
}
