package com.af.v4.system.restful.service;

import com.af.v4.system.api.RemoteEntityService;
import com.af.v4.system.common.core.constant.SecurityConstants;
import com.af.v4.system.common.core.domain.R;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * 远程调用实体服务
 *
 * @author Mr.river
 */
@Service
public class LocalEntityService {
    private final RemoteEntityService entityService;

    private final Logger LOGGER = LoggerFactory.getLogger(LocalEntityService.class);

    public LocalEntityService(RemoteEntityService entityService) {
        this.entityService = entityService;
    }

    //    @GlobalTransactional
    public JSONObject partialSave(String entityName, JSONObject entity) {
        R<Map<String, Object>> entityResult = entityService.save(entityName, entity.toString(), SecurityConstants.INNER);
        return entityResult.parseResponseJson();
    }

    public JSONObject batchSave(String entityName, JSONObject entity) {
        R<List<Object>> entityResult = entityService.saveBatch(entityName, entity.toString(), SecurityConstants.INNER);
        return entityResult.parseResponseJson();
    }

    public JSONObject deleteById(String entityName, Object id) {
        R<Map<String, Object>> entityResult = entityService.deleteById(entityName, String.valueOf(id), SecurityConstants.INNER);
        return entityResult.parseResponseJson();
    }

    public JSONObject deleteAllByIds(String entityName, JSONArray ids) {
        JSONObject content = new JSONObject();
        content.put("ids", ids);
        R<Map<String, Object>> entityResult = entityService.deleteAllByIds(entityName, content.toString(), SecurityConstants.INNER);
        return entityResult.parseResponseJson();
    }

    public JSONObject getById(String entityName, Object id) {
        return getById(null, entityName, id);
    }

    public JSONObject getById(String columns, String entityName, Object id) {
        JSONObject content = new JSONObject();
        if(columns != null) {
            content.put("columns", columns);
        }
        R<Map<String, Object>> entityResult = entityService.getById(entityName, String.valueOf(id), content.toString(), SecurityConstants.INNER);
        return entityResult.parseResponseJson();
    }

    public JSONObject findAllByIds(String entityName, JSONArray ids) {
        return findAllByIds(null, entityName, ids);
    }

    public JSONObject findAllByIds(String columns, String entityName, JSONArray ids) {
        JSONObject content = new JSONObject();
        content.put("ids", ids);
        if(columns != null) {
            content.put("columns", columns);
        }
        R<List<Object>> entityResult = entityService.findAllByIds(entityName, content.toString(), SecurityConstants.INNER);
        return entityResult.parseResponseJson();
    }
}
