package com.af.v4.system.restful.mq;

import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;

public class RocketMQProducer {
	// 消息生产者Producer
	private DefaultMQProducer defaultMQProducer;
	private String producerGroup;
	private String namesrvAddr;

	public void init() throws MQClientException {
		this.defaultMQProducer = new DefaultMQProducer(this.producerGroup);
		// 设置NameServer的地址
		defaultMQProducer.setNamesrvAddr(this.namesrvAddr);
		// 启动Producer实例
		defaultMQProducer.start();
	}

	public DefaultMQProducer getDefaultMQProducer() {
		return defaultMQProducer;
	}

	public void destroy() {
		defaultMQProducer.shutdown();
	}

	public RocketMQProducer setProducerGroup(String producerGroup) {
		this.producerGroup = producerGroup;
		return this;
	}

	public RocketMQProducer setNamesrvAddr(String namesrvAddr) {
		this.namesrvAddr = namesrvAddr;
		return this;
	}
}
