package com.af.v4.system.restful.mapper;

import org.dom4j.Element;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * logic映射器
 *
 * @author Mr.river
 */
@Component
public class LogicMapper extends AbstractResourceMapper<String> {
    protected LogicMapper(ModuleMapper moduleMapper) {
        super(moduleMapper);
    }

    @Override
    protected String getResType() {
        return "logic";
    }

    @Override
    protected String getFileName() {
        return "logic.xml";
    }

    @Override
    protected String getFolderName() {
        return "logics";
    }

    @Override
    protected Map<String, String> appendRes(Element element, String moduleName, String parentModuleName) {
        Map<String, String> res = super.appendRes(element, moduleName, parentModuleName);
        // 追加元素
        String log = element.attributeValue("log");
        String mobile = element.attributeValue("mobile");
        // 所属数据源
        String dataSource = element.attributeValue("dataSource");
        res.put("log", log);
        res.put("mobile", mobile);
        res.put("dataSource", dataSource);
        return res;
    }
}
