package com.af.v4.system.restful.config;

import com.af.v4.system.restful.sql.dynamic.DynamicDataSource;
import com.alibaba.druid.pool.DruidDataSource;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Configuration
@ConfigurationProperties(prefix = "db")
@Component
public class DynamicDataSourceConfig {

    private List<DruidDataSource> dataSourceList;

    @Bean
    @Primary
    public DynamicDataSource routingDataSource() {
        // 循环加入数据源，实例化动态数据源工具类
        Map<Object, Object> targetDataSources = new HashMap<>(dataSourceList.size());
        dataSourceList.forEach(item -> targetDataSources.put(item.getName(), item));
        return new DynamicDataSource(dataSourceList.get(0), targetDataSources);
    }

    public List<DruidDataSource> getDataSourceList() {
        return dataSourceList;
    }

    public void setDataSourceList(List<DruidDataSource> dataSourceList) {
        this.dataSourceList = dataSourceList;
    }
}
