/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.service;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.expression.Expression;
import com.af.v4.system.restful.exception.FileNotFoundException;
import com.af.v4.system.restful.mapper.ResourceMapper;
import com.af.v4.system.restful.mapper.SqlMapper;
import com.af.v4.system.restful.sql.SqlAction;
import com.af.v4.system.restful.utils.enums.ResourceType;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class SqlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlService.class);
    private final ResourceMapper resourceMapper;
    private final SqlMapper sqlMapper;
    private final SqlAction sqlAction;

    public SqlService(ResourceMapper resourceMapper, SqlMapper sqlMapper, SqlAction sqlAction) {
        this.resourceMapper = resourceMapper;
        this.sqlMapper = sqlMapper;
        this.sqlAction = sqlAction;
    }

    public String getSQL(String name, JSONObject params) {
        Map map = params.toMap();
        return this.call(name, map);
    }

    public JSONObject queryTotal(String name, String str) {
        JSONObject param;
        Object sums = null;
        if (str != null && !str.isEmpty()) {
            JSONObject json = new JSONObject(str);
            param = json.has("data") ? json.getJSONObject("data") : new JSONObject();
            if (json.has("sums")) {
                sums = json.get("sums");
            }
        } else {
            param = new JSONObject();
        }
        Map params = param.toMap();
        String sql = this.call(name, params);
        sql = this.filterOutOrderBy(sql, sums);
        JSONArray array = this.sqlAction.query(sql);
        return array.getJSONObject(0);
    }

    @Deprecated
    public JSONArray query(String sql) {
        return this.querySQL(sql);
    }

    public JSONArray query(String name, String str) {
        return this.query(name, 0, 1000, str);
    }

    public JSONArray query(String name, JSONObject params) {
        Map map = params.toMap();
        return this.query(name, 1, 1000, map);
    }

    public JSONArray query(String name, JSONObject params, Integer pageSize) {
        Map map = params.toMap();
        return pageSize <= 0 ? this.query(name, 1, 9999999, map) : this.query(name, 1, (int)pageSize, map);
    }

    public JSONArray query(String name, Map<String, Object> params) {
        return this.query(name, 1, 1000, params);
    }

    public JSONArray query(String name, Map<String, Object> params, Integer pageSize) {
        return pageSize <= 0 ? this.query(name, 1, 9999999, params) : this.query(name, 1, (int)pageSize, params);
    }

    public JSONArray query(String name, int pageNo, int pageSize, String str) {
        JSONObject param;
        if (pageNo <= 0) {
            pageNo = 1;
        }
        if (pageSize < 1) {
            pageSize = 1000;
        }
        if (str != null && !str.isEmpty()) {
            param = new JSONObject(str);
            param = param.getJSONObject("data");
        } else {
            param = new JSONObject();
        }
        Map params = param.toMap();
        return this.query(name, pageNo, pageSize, params);
    }

    public JSONArray query(String name, int pageNo, int pageSize, Map<String, Object> params) {
        String sql = this.call(name, params);
        JSONArray array = this.sqlAction.query(sql, pageNo - 1, pageSize);
        LOGGER.info("SQL[" + name + "] Result: \n" + array.toString());
        return array;
    }

    public JSONArray query(String name, String str, Integer pageSize) {
        return pageSize <= 0 ? this.query(name, 1, 9999999, str) : this.query(name, 1, (int)pageSize, str);
    }

    public JSONArray querySQL(String sql) {
        return this.querySQL(sql, 1, 9999999, false);
    }

    public JSONArray querySQL(String sql, boolean isNoLog) {
        return this.querySQL(sql, 1, 9999999, isNoLog);
    }

    public JSONArray querySQL(String sql, Integer pageSize) {
        return this.querySQL(sql, pageSize, false);
    }

    public JSONArray querySQL(String sql, Integer pageSize, boolean isNoLog) {
        return pageSize <= 0 ? this.querySQL(sql, 1, 9999999, isNoLog) : this.querySQL(sql, 1, pageSize, isNoLog);
    }

    public JSONArray querySQL(String sql, int pageNo, int pageSize) {
        return this.querySQL(sql, pageNo, pageSize, false);
    }

    public JSONArray querySQL(String sql, int pageNo, int pageSize, boolean isNoLog) {
        JSONArray array = this.sqlAction.query(sql, pageNo - 1, pageSize, isNoLog);
        if (!isNoLog) {
            LOGGER.info("SQL Result: \n" + array.toString());
        }
        return array;
    }

    public void run(String sql) throws NullPointerException {
        this.sqlAction.bulkSQLUpdate(sql);
    }

    public void run(String sql, Object ... params) {
        String useSql = String.format(sql.replace("{}", "%s"), params);
        this.sqlAction.bulkSQLUpdate(useSql);
    }

    public Integer runByName(String name, JSONObject params) {
        String sql = this.call(name, params);
        return this.sqlAction.bulkSQLUpdate(sql);
    }

    public Integer runByName(String name, String params) {
        return this.runByName(name, new JSONObject(params));
    }

    public int runSQL(String sql) {
        return this.sqlAction.bulkSQLUpdate(sql);
    }

    public int runSQL(String sql, Object ... params) {
        String useSql = String.format(sql.replace("{}", "%s"), params);
        return this.sqlAction.bulkSQLUpdate(useSql);
    }

    public String call(String sqlName, JSONObject json) {
        Map param = json.toMap();
        return this.call(sqlName, param);
    }

    public String call(String sqlName, Map<String, Object> params) {
        String sql;
        String path = this.sqlMapper.getValue(sqlName);
        if (path == null) {
            throw new ServiceException("sql\u8bed\u53e5\u672a\u6ce8\u518c\uff01" + sqlName);
        }
        try {
            sql = this.resourceMapper.getString(ResourceType.SQL, sqlName, path);
            if (sql.contains("${")) {
                sql = sql.replace("${", "{");
            }
        }
        catch (FileNotFoundException e) {
            throw new ServiceException(path + ".\u6587\u4ef6\u65e0\u914d\u7f6e");
        }
        params.put("sql", this);
        sql = Expression.run((String)sql, params).toString();
        return sql;
    }

    private String filterOutOrderBy(String source, Object sums) {
        int idx = source.toLowerCase().lastIndexOf("order by");
        if (idx == -1) {
            idx = source.length() - 1;
        }
        StringBuilder sql = new StringBuilder("select ");
        if (sums != null) {
            if (sums instanceof JSONArray) {
                JSONArray arraySums = (JSONArray)sums;
                for (int i = 0; i < arraySums.length(); ++i) {
                    String name = (String)arraySums.get(i);
                    sql.append("sum(").append(name).append(") ").append(name).append(", ");
                }
            } else if (sums instanceof JSONObject) {
                JSONObject objSums = (JSONObject)sums;
                Iterator keys = objSums.keys();
                while (keys.hasNext()) {
                    String name = (String)keys.next();
                    String value = objSums.getString(name);
                    sql.append("sum(").append(value).append(") ").append(name).append(", ");
                }
            }
        }
        if (idx != -1) {
            sql.append("count(*) n, 1 placeholder from ( ").append(source, 0, idx).append(") t_");
        }
        return sql.toString();
    }
}

