/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.sql;

import com.af.v4.system.restful.sql.AliasTransformer;
import com.af.v4.system.restful.transaction.SessionPool;
import java.util.Collection;
import org.hibernate.Session;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.stereotype.Component;

@Component
public class SqlAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(SqlAction.class);
    private final SessionPool sessionPool;

    public SqlAction(SessionPool sessionPool) {
        this.sessionPool = sessionPool;
    }

    public JSONArray query(String sql) {
        return this.query(sql, 0, 9999999, false);
    }

    public JSONArray query(String sql, int pageNo, int pageSize) {
        return this.query(sql, pageNo, pageSize, false);
    }

    public JSONArray query(String sql, int pageNo, int pageSize, boolean isNoLog) {
        return (JSONArray)this.sqlMonitor(() -> {
            HibernateSQLCall sqlCall = new HibernateSQLCall(sql, pageNo, pageSize);
            sqlCall.transformer = AliasTransformer.INSTANCE;
            return sqlCall.doInHibernate(this.sessionPool.getSession());
        }, sql, isNoLog);
    }

    public int bulkSQLUpdate(String sql) {
        return (Integer)this.sqlMonitor(() -> {
            Session session = this.sessionPool.getSession();
            NativeQuery queryObject = session.createNativeQuery(sql);
            return queryObject.executeUpdate();
        }, sql, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object sqlMonitor(Process process, String sql, boolean isNoLog) {
        long begin = System.currentTimeMillis();
        try {
            Object object = process.apply();
            return object;
        }
        finally {
            long end = System.currentTimeMillis();
            if (!isNoLog) {
                LOGGER.debug("\u7ef4\u62a4\u4fe1\u606f:\u6267\u884cSQL\u8017\u65f6\uff1a" + (end - begin) + "ms:{\n" + sql + "\n}");
            }
        }
    }

    @FunctionalInterface
    static interface Process {
        public Object apply();
    }

    private static class HibernateSQLCall
    implements HibernateCallback<JSONArray> {
        final String sql;
        final int page;
        final int rows;
        public ResultTransformer transformer = null;

        public HibernateSQLCall(String sql, int page, int rows) {
            this.sql = sql;
            this.page = page;
            this.rows = rows;
        }

        public JSONArray doInHibernate(Session session) {
            NativeQuery q = session.createNativeQuery(this.sql);
            if (this.transformer != null) {
                q.setResultTransformer(this.transformer);
            }
            try {
                return new JSONArray((Collection)q.setFirstResult(this.page * this.rows).setMaxResults(this.rows).list());
            }
            catch (SQLGrammarException ex) {
                String msg = "sql:\n" + this.sql + "\n" + ex.getMessage();
                throw new SQLGrammarException(msg, ex.getSQLException());
            }
        }
    }
}

