/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.utils;

import com.af.v4.system.expression.Program;
import com.af.v4.system.plugins.core.CommonTools;
import com.af.v4.system.plugins.io.IOTools;
import com.af.v4.system.restful.exception.FileNotFoundException;
import com.af.v4.system.restful.mapper.LogicMapper;
import com.af.v4.system.restful.mapper.ModuleMapper;
import com.af.v4.system.restful.mapper.ResourceMapper;
import com.af.v4.system.restful.mapper.SqlMapper;
import com.af.v4.system.restful.utils.enums.ResourceType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ResCheckUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResCheckUtil.class);
    private static final List<String> ERROR_ARRAY = new ArrayList<String>();
    private static final String[] sentence = new String[]{"\u8f6f\u4ef6\u5f00\u53d1\u5f80\u5f80\u662f\u8fd9\u6837\uff1a\u6700\u5f00\u59cb\u768490%\u4ee3\u7801\u5360\u7528\u4e86\u5f00\u59cb\u768490%\u7684\u5f00\u53d1\u65f6\u95f4\uff1b\u5269\u4e0b10%\u4ee3\u7801\u540c\u6837\u9700\u898190%\u7684\u5f00\u53d1\u65f6\u95f4\u3002", "\u8fd9\u4e0d\u662f\u4e00\u4e2abug\uff0c\u8fd9\u53ea\u662f\u4e00\u4e2a\u672a\u5217\u51fa\u6765\u7684\u7279\u6027\u3002", "\u4f5c\u4e3a\u4e00\u4e2a\u7a0b\u5e8f\u5458\uff0c\u90c1\u95f7\u7684\u4e8b\u60c5\u662f\uff0c\u2faf\u5bf9\u4e00\u4e2a\u4ee3\u7801\u5757\uff0c\u5374\u4e0d\u6562\u53bb\u4fee\u6539\u3002\u66f4\u7cdf\u7cd5\u7684\u662f\uff0c\u8fd9\u4e2a\u4ee3\u7801\u5757\u8fd8\u662f\u2f83\u2f30\u5199\u7684\u3002", "\u5728\u7cfb\u7edf\u6d4b\u8bd5\u9636\u6bb5\u67e5\u627e\u5e76\u4fee\u590d Bug\uff0c\u82b1\u8d39\u7684\u65f6\u95f4\u548c\u5de5\u4f5c\u91cf\u662f\u8ba9\u5f00\u53d1\u8005\u81ea\u5df1\u627e Bug \u7684\u4e09\u500d\u3002\u5728\u6b63\u5f0f\u4e0a\u7ebf\u540e\u67e5\u627e\u5e76\u4fee\u590d Bug\uff0c\u82b1\u8d39\u7684\u65f6\u95f4\u548c\u5de5\u4f5c\u91cf\u662f\u7cfb\u7edf\u6d4b\u8bd5\u9636\u6bb5\u7684\u5341\u500d\u3002\u56e0\u6b64\u4e00\u5b9a\u8981\u8ba9\u5f00\u53d1\u8005\u81ea\u5df1\u505a\u5355\u5143\u6d4b\u8bd5\u3002", "\u4e0d\u8981\u7ad9\u7740\u8c03\u8bd5\u3002\u7ad9\u7740\u4f1a\u8ba9\u4f60\u7684\u8010\u5fc3\u51cf\u534a\uff0c\u800c\u4e14\u4f60\u9700\u8981\u96c6\u4e2d\u6240\u6709\u7cbe\u529b\u3002", "\u6d4b\u8bd5\u53ef\u4ee5\u53d1\u73b0bug\u7684\u5b58\u5728\uff0c\u4f46\u4e0d\u80fd\u8bc1\u660ebug\u4e0d\u5b58\u5728\u3002", "\u65b0\u7cfb\u7edf\u7684\u6bcf\u4e2a\u65b0\u7528\u6237\u90fd\u4f1a\u53d1\u73b0\u4e00\u7c7b\u65b0\u7684Bug\u3002", "\u4fee\u590d\u635f\u574f\u7684\u7a0b\u5e8f\u7684\u7b2c\u4e00\u6b65\u5c31\u662f\u8ba9\u5b83\u4e0d\u65ad\u5931\u8d25\u3002", "\u6709\u4e24\u79cd\u65b9\u6cd5\u80fd\u5199\u51fa\u6ca1\u6709\u9519\u8bef\u7684\u7a0b\u5e8f\uff1b\u4f46\u53ea\u6709\u7b2c\u4e09\u79cd\u597d\u7528\u3002", "\u4ee3\u7801\u5199\u7684\u8d8a\u6025\uff0c\u7a0b\u5e8f\u8dd1\u5f97\u8d8a\u6162\u3002", "\u5728\u6240\u6709\u7684\u7a0b\u5e8f\u9519\u8bef\u4e2d\uff0c80%\u662f\u8bed\u6cd5\u9519\u8bef\uff0c\u5269\u4e0b20%\u91cc\uff0c80%\u662f\u7b80\u5355\u7684\u903b\u8f91\u9519\u8bef\uff0c\u518d\u5269\u4e0b4%\u91cc\uff0c80%\u662f\u6307\u9488\u9519\u8bef\uff0c\u53ea\u6709\u4f59\u4e0b\u76840.8%\u624d\u662f\u56f0\u96be\u7684\u95ee\u9898\u3002"};
    private final ResourceMapper resourceMapper;
    private final SqlMapper sqlMapper;
    private final ModuleMapper moduleMapper;
    private final LogicMapper logicMapper;

    public ResCheckUtil(ResourceMapper resourceMapper, SqlMapper sqlMapper, ModuleMapper moduleMapper, LogicMapper logicMapper) {
        this.resourceMapper = resourceMapper;
        this.sqlMapper = sqlMapper;
        this.moduleMapper = moduleMapper;
        this.logicMapper = logicMapper;
    }

    @PostConstruct
    public void checkAll() {
        LOGGER.info("==================\u5f00\u59cb\u8d44\u6e90\u5f3a\u5236\u68c0\u67e5==================");
        Map<String, Map<String, String>> map = this.moduleMapper.getMap();
        int GrammarErrorNums = 0;
        int GrammarErrorSQLNums = 0;
        for (String module : map.keySet()) {
            String modulePath = map.get(module).get("path");
            String logicUrl = modulePath == null ? module + "/logic.xml" : modulePath + "/" + module + "/logic.xml";
            String sqlUrl = modulePath == null ? module + "/sql.xml" : modulePath + "/" + module + "/sql.xml";
            GrammarErrorNums += this.checkLogicGrammar(module, logicUrl);
            GrammarErrorSQLNums += this.checkSqlResource(module, sqlUrl);
        }
        boolean throwError = false;
        Object msg = "\u68c0\u67e5\u7ed3\u679c\uff1a";
        if (GrammarErrorNums > 0) {
            throwError = true;
            msg = (String)msg + "\n * >>> Logic\u5f3a\u5236\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u5171\u6709" + GrammarErrorNums + "\u9879\u9519\u8bef";
        }
        if (GrammarErrorSQLNums > 0) {
            throwError = true;
            msg = (String)msg + "\n * >>> SQL\u5f3a\u5236\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u5171\u6709" + GrammarErrorSQLNums + "\u9879\u9519\u8bef";
        }
        msg = (String)msg + "\n * >>> \u81f3\u7406\u540d\u8a00\uff1a" + sentence[CommonTools.getRandomNumber((Integer)0, (Integer)(sentence.length - 1))];
        if (throwError) {
            Object errorWelcome = "/***\n * _ooOoo_\n * o8888888o\n * 88\" . \"88\n * (| -_- |)\n *  O\\ = /O\n * ___/`---'\\____\n * .   ' \\\\| |// `.\n * / \\\\||| : |||// \\\n * / _||||| -:- |||||- \\\n * | | \\\\\\ - /// | |\n * | \\_| ''\\---/'' | |\n * \\ .-\\__ `-` ___/-. /\n * ___`. .' /--.--\\ `. . __\n * .\"\" '< `.___\\_<|>_/___.' >'\"\".\n * | | : `- \\`.;`\\ _ /`;.`/ - ` : | |\n * \\ \\ `-. \\_ __\\ /__ _/ .-` / /\n * ======`-.____`-.___\\_____/___.-`____.-'======\n * `=---='\n * .............................................\n * \u4f5b\u66f0\uff1abug\u6cdb\u6ee5\uff0c\u6211\u5df2\u762b\u75ea\uff01\n";
            errorWelcome = (String)errorWelcome + "\n * " + (String)msg + "\n";
            LOGGER.error((String)errorWelcome);
            for (int i = 0; i < ERROR_ARRAY.size(); ++i) {
                StringBuilder item = new StringBuilder();
                LOGGER.error(item.append(" * ").append(i).append(". ").append(ERROR_ARRAY.get(i)).toString());
            }
            LOGGER.error("==================\u8d44\u6e90\u5f3a\u5236\u68c0\u67e5\u5b8c\u6210==================\n");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            throw new RuntimeException("Logic\u6216SQL\u5f3a\u5236\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u7a0b\u5e8f\u5df2\u5f3a\u5236\u4e2d\u6b62\uff0c\u8bf7\u5728\u5e94\u7528\u65e5\u5fd7\u4e2d\u67e5\u770b\u9519\u8bef\u8be6\u60c5");
        }
        String successWelcome = "/***\n *                    _ooOoo_\n *                   o8888888o\n *                   88\" . \"88\n *                   (| -_- |)\n *                    O\\ = /O\n *                ____/`---'\\____\n *              .   ' \\\\| |// `.\n *               / \\\\||| : |||// \\\n *             / _||||| -:- |||||- \\\n *               | | \\\\\\ - /// | |\n *             | \\_| ''\\---/'' | |\n *              \\ .-\\__ `-` ___/-. /\n *           ___`. .' /--.--\\ `. . __\n *        .\"\" '< `.___\\_<|>_/___.' >'\"\".\n *       | | : `- \\`.;`\\ _ /`;.`/ - ` : | |\n *         \\ \\ `-. \\_ __\\ /__ _/ .-` / /\n * ======`-.____`-.___\\_____/___.-`____.-'======\n *                    `=---='\n *\n * .............................................\n *          \u4f5b\u7956\u4fdd\u4f51             \u6c38\u65e0BUG\n */";
        LOGGER.info(successWelcome);
    }

    private int checkSqlResource(String module, String sqlUrl) {
        AtomicInteger errorNums = new AtomicInteger();
        IOTools.getStream((String)sqlUrl, stream -> {
            Element root = this.loadDocument(stream);
            List sqls = root.elements("sql");
            LOGGER.debug("\u68c0\u67e5\u3010" + module + "\u3011\u6a21\u5757\u4e0bSql\u8d44\u6e90\u6620\u5c04\uff0c\u5171 " + sqls.size() + " \u4e2a...");
            AtomicInteger i = new AtomicInteger(1);
            AtomicInteger success = new AtomicInteger(0);
            AtomicInteger error = new AtomicInteger(0);
            sqls.forEach(it -> {
                String index = "(" + i + "/" + sqls.size() + ")";
                String alias = it.attribute("alias").getValue();
                String path = this.sqlMapper.getValue(alias);
                if (path == null) {
                    ERROR_ARRAY.add("Sql\u3010" + alias + "\u3011\u672a\u914d\u7f6e" + index);
                    error.set(error.get() + 1);
                } else {
                    try {
                        this.resourceMapper.getString(ResourceType.SQL, alias, path);
                        success.set(success.get() + 1);
                    }
                    catch (FileNotFoundException e) {
                        ERROR_ARRAY.add("Sql\u3010" + alias + "\u3011\u672a\u627e\u5230\u6587\u4ef6\uff1a" + path);
                        error.set(error.get() + 1);
                    }
                }
                i.set(i.get() + 1);
            });
            LOGGER.debug("\u3010" + module + "\u3011\u6a21\u5757\u8bed\u6cd5\u68c0\u67e5\u5b8c\u6210\uff0c\u5171 " + sqls.size() + "\u4e2a,\u6b63\u786e" + success.get() + " \u4e2a,\u9519\u8bef " + error.get() + " \u4e2a");
            errorNums.set(errorNums.get() + error.get());
        });
        return errorNums.get();
    }

    private Element loadDocument(InputStream stream) {
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(stream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        assert (document != null);
        return document.getRootElement();
    }

    private int checkLogicGrammar(String module, String logicUrl) {
        AtomicInteger errorNums = new AtomicInteger();
        IOTools.getStream((String)logicUrl, stream -> {
            Element root = this.loadDocument(stream);
            List logics = root.elements("logic");
            LOGGER.debug("\u68c0\u67e5\u3010" + module + "\u3011\u6a21\u5757\u4e0bLogic\u8bed\u6cd5\uff0c\u5171 " + logics.size() + " \u4e2a...");
            AtomicInteger i = new AtomicInteger(1);
            AtomicInteger success = new AtomicInteger(0);
            AtomicInteger error = new AtomicInteger(0);
            ResourceMapper.CACHE_MODE metaMode = ResourceMapper.mode;
            ResourceMapper.mode = ResourceMapper.CACHE_MODE.DEBUG;
            logics.forEach(it -> {
                String index = "(" + i + "/" + logics.size() + ")";
                String alias = it.attribute("alias").getValue();
                String path = (String)this.logicMapper.getValue(alias);
                if (path == null) {
                    ERROR_ARRAY.add("Logic\u3010" + alias + "\u3011\u672a\u914d\u7f6e" + index);
                    error.set(error.get() + 1);
                } else {
                    try {
                        String source = this.resourceMapper.getString(ResourceType.LOGIC, alias, path);
                        Program pros = new Program(source);
                        try {
                            pros.parse();
                            success.set(success.get() + 1);
                        }
                        catch (RuntimeException e) {
                            String message = e.getMessage();
                            ERROR_ARRAY.add("Logic\u3010" + alias + "\u3011\u7f16\u8bd1\u9519\u8bef\uff1a" + message);
                            error.set(error.get() + 1);
                        }
                    }
                    catch (FileNotFoundException e) {
                        ERROR_ARRAY.add("Logic\u3010" + alias + "\u3011\u672a\u627e\u5230\u6587\u4ef6\uff1a" + path);
                        error.set(error.get() + 1);
                    }
                }
                i.set(i.get() + 1);
            });
            ResourceMapper.mode = metaMode;
            LOGGER.debug("\u3010" + module + "\u3011\u6a21\u5757\u8bed\u6cd5\u68c0\u67e5\u5b8c\u6210\uff0c\u5171 " + logics.size() + " \u4e2a,\u6b63\u786e " + success.get() + " \u4e2a,\u9519\u8bef " + error.get() + " \u4e2a");
            errorNums.set(errorNums.get() + error.get());
        });
        return errorNums.get();
    }
}

