/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.service;

import com.af.v4.system.api.RemoteLogicService;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.restful.exception.FileNotFoundException;
import com.af.v4.system.restful.logic.ExpressionHelper;
import com.af.v4.system.restful.mapper.LogicMapper;
import com.af.v4.system.restful.mapper.PluginMapper;
import com.af.v4.system.restful.mapper.ResourceMapper;
import com.af.v4.system.restful.service.ExceptionLogService;
import com.af.v4.system.restful.service.LocalEntityService;
import com.af.v4.system.restful.service.SqlService;
import com.af.v4.system.restful.transaction.SessionPool;
import com.af.v4.system.restful.utils.ExceptionHelper;
import com.af.v4.system.restful.utils.enums.ResourceType;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LogicService {
    private static final Logger LOGGER = LogManager.getLogger(LogicService.class);
    private final SqlService sqlService;
    private final SessionPool sessionPool;
    private final ResourceMapper resourceMapper;
    private final RedisService redisService;
    private final RemoteLogicService remoteLogicService;
    private final LocalEntityService entityService;
    private final PluginMapper pluginMapper;
    private final LogicMapper logicMapper;

    public LogicService(SqlService sqlService, SessionPool sessionPool, ResourceMapper resourceMapper, RedisService redisService, RemoteLogicService remoteLogicService, LocalEntityService entityService, PluginMapper pluginMapper, LogicMapper logicMapper) {
        this.sqlService = sqlService;
        this.sessionPool = sessionPool;
        this.resourceMapper = resourceMapper;
        this.redisService = redisService;
        this.remoteLogicService = remoteLogicService;
        this.entityService = entityService;
        this.pluginMapper = pluginMapper;
        this.logicMapper = logicMapper;
    }

    @Transactional(rollbackFor={Exception.class})
    public Object run(String name, String str) {
        JSONObject param = null;
        if ((str = str.trim()).startsWith("<") && str.endsWith(">")) {
            param = new JSONObject();
            param.put("xml", (Object)str);
        } else {
            Object json = new JSONTokener(str).nextValue();
            if (json instanceof JSONObject) {
                Object dataParam;
                JSONObject st = (JSONObject)json;
                param = st;
                if (!param.isNull("data") && (dataParam = param.get("data")) instanceof JSONObject) {
                    param = (JSONObject)dataParam;
                    param.put("standardData", (Object)new JSONObject(str).toString());
                }
            } else if (json instanceof JSONArray) {
                JSONArray ar = (JSONArray)json;
                param = new JSONObject();
                param.put("arr", (Object)ar);
            }
        }
        return this.run(name, param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public Object run(String name, JSONObject param) {
        String source;
        String message = "\u7ef4\u62a4\u4fe1\u606f:\u5f00\u59cb\u6267\u884cLogic[" + name + "]\uff0c\u53c2\u6570\uff1a" + param;
        LOGGER.debug(message);
        String path = (String)this.logicMapper.getValue(name);
        if (path == null) {
            throw new ServiceException("\u4e1a\u52a1\u903b\u8f91\u672a\u627e\u5230: " + name);
        }
        try {
            source = this.resourceMapper.getString(ResourceType.LOGIC, name, path);
        }
        catch (FileNotFoundException e) {
            throw new ServiceException(path + ".\u6587\u4ef6\u65e0\u914d\u7f6e");
        }
        Map<String, Object> params = this.pluginMapper.getAllMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, object -> ((Map)object.getValue()).get("value")));
        params.put("data", param);
        params.put("log", LOGGER);
        params.put("entity", this.entityService);
        params.put("sql", this.sqlService);
        params.put("session", this.sessionPool.getSession());
        params.put("redis", this.redisService);
        params.put("logic", this);
        long begin = System.currentTimeMillis();
        try {
            Object result;
            Object object2 = result = ExpressionHelper.run(source, params);
            return object2;
        }
        finally {
            long end = System.currentTimeMillis();
            long time = end - begin;
            String engMessage = "\u7ef4\u62a4\u4fe1\u606f:\u6267\u884cLogic[" + name + "]\u8017\u65f6:" + time;
            if (time >= 8000L) {
                LOGGER.error(engMessage);
            } else if (time >= 4000L) {
                LOGGER.warn(engMessage);
            } else {
                LOGGER.debug(engMessage);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public Object runMain(String logicName, String values) {
        try {
            Object result = this.run(logicName, values);
            if (result == null) {
                return "";
            }
            return result;
        }
        catch (Exception ex) {
            String stack = ExceptionLogService.getErrorInfo(ExceptionHelper.stackToString(ex), 1);
            ServiceException serviceException = null;
            if (ex instanceof ServiceException) {
                ServiceException e;
                serviceException = e = (ServiceException)ex;
            } else {
                InvocationTargetException targetException;
                Throwable throwable;
                Throwable throwable2 = ex.getCause();
                if (throwable2 instanceof InvocationTargetException && (throwable = (targetException = (InvocationTargetException)throwable2).getTargetException()) instanceof ServiceException) {
                    ServiceException e;
                    serviceException = e = (ServiceException)throwable;
                }
            }
            if (serviceException != null) {
                serviceException.setDetailMessage(stack);
            } else {
                serviceException = new ServiceException();
                serviceException.setMessage("\u670d\u52a1\u5668\u5185\u90e8\u9519\u8bef");
                serviceException.setDetailMessage(stack);
            }
            throw serviceException;
        }
    }

    public JSONObject remoteRun(String serviceName, String logicName, String params) {
        R logicResult = this.remoteLogicService.run(serviceName, logicName, params, "inner");
        return logicResult.parseResponseJson();
    }

    public JSONObject remoteRun(String serviceName, String logicName, JSONObject params) {
        return this.remoteRun(serviceName, logicName, params.toString());
    }
}

