/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.mapper;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.plugins.io.IOTools;
import com.af.v4.system.restful.exception.FileNotFoundException;
import com.af.v4.system.restful.utils.enums.ResourceType;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Component;

@Component
public record ResourceMapper(RedisService redisService) {
    private static final ConcurrentHashMap<String, String> CACHE_LOGIC_MAP;
    private static final ConcurrentHashMap<String, String> CACHE_SQL_MAP;
    public static CACHE_MODE mode;

    public static String getString(String fileName) throws FileNotFoundException {
        return IOTools.getStringByReader((String)fileName, bufferedReader -> {
            String line;
            StringBuilder sb = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line).append("\r\n");
            }
            return sb;
        }, errorPath -> {
            throw new FileNotFoundException(fileName + "\u6587\u4ef6\u4e0d\u5b58\u5728", fileName);
        }).toString();
    }

    public static void clearLogicCache() {
        CACHE_LOGIC_MAP.clear();
    }

    public static void clearSqlCache() {
        CACHE_SQL_MAP.clear();
    }

    public String getString(ResourceType resourceType, String alias, String fileName) throws FileNotFoundException {
        switch (resourceType) {
            case LOGIC: {
                if (mode == CACHE_MODE.NORMAL && CACHE_LOGIC_MAP.containsKey(alias)) {
                    return CACHE_LOGIC_MAP.get(alias);
                }
                String sourceStr = ResourceMapper.getString(fileName);
                sourceStr = sourceStr.replace("\r\n", "\n");
                if (mode == CACHE_MODE.NORMAL) {
                    CACHE_LOGIC_MAP.put(alias, sourceStr);
                }
                return sourceStr;
            }
            case SQL: {
                if (mode == CACHE_MODE.NORMAL && CACHE_SQL_MAP.containsKey(alias)) {
                    return CACHE_SQL_MAP.get(alias);
                }
                Object source = ResourceMapper.getString(fileName);
                source = ((String)source).replace("\r\n", "\n");
                source = "$" + (String)source;
                if (mode == CACHE_MODE.NORMAL) {
                    CACHE_SQL_MAP.put(alias, (String)source);
                }
                return source;
            }
        }
        throw new ServiceException("\u9519\u8bef\u7684\u7f13\u5b58\u6570\u636e\u7c7b\u578b");
    }

    static {
        mode = CACHE_MODE.NORMAL;
        CACHE_LOGIC_MAP = new ConcurrentHashMap(10);
        CACHE_SQL_MAP = new ConcurrentHashMap(10);
    }

    public static enum CACHE_MODE {
        NORMAL,
        DEBUG;

    }
}

