/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.restful.config;

import com.af.v4.system.restful.config.SystemConfig;
import java.util.Properties;
import javax.sql.DataSource;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;

@Configuration
@ConfigurationProperties(prefix="spring.datasource")
public class HibernateConfig {
    public final String currentSessionContextClass = "org.springframework.orm.hibernate5.SpringSessionContext";
    private final DataSource dataSource;
    private final ApplicationContext context;
    private final Logger LOGGER = LoggerFactory.getLogger(HibernateConfig.class);

    public HibernateConfig(DataSource dataSource, ApplicationContext context) {
        this.dataSource = dataSource;
        this.context = context;
    }

    @Bean
    public LocalSessionFactoryBean sessionFactoryBean() {
        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
        sessionFactoryBean.setDataSource(this.dataSource);
        sessionFactoryBean.setPackagesToScan(new String[]{"com.af.v4.entity"});
        Properties properties = new Properties();
        properties.setProperty("hibernate.hbm2ddl.auto", "update");
        properties.setProperty("hibernate.show_sql", "false");
        properties.setProperty("hibernate.format_sql", "false");
        properties.setProperty("hibernate.current_session_context_class", "org.springframework.orm.hibernate5.SpringSessionContext");
        String dialect = SystemConfig.Hibernate.getDialect();
        properties.setProperty("hibernate.dialect", dialect);
        sessionFactoryBean.setHibernateProperties(properties);
        JSONArray cfgLocations = SystemConfig.Hibernate.getCfgLocations();
        Resource[] cfgLocationResources = cfgLocations.toList().stream().map(item -> this.context.getResource((String)item)).toList().toArray(new Resource[cfgLocations.length()]);
        sessionFactoryBean.setConfigLocations(cfgLocationResources);
        return sessionFactoryBean;
    }

    @Bean
    public HibernateTransactionManager transactionManager() {
        HibernateTransactionManager transactionManager = new HibernateTransactionManager();
        transactionManager.setSessionFactory(this.sessionFactoryBean().getObject());
        return transactionManager;
    }
}

