package com.af.v4.system.restful.transaction;

import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.internal.SessionFactoryImpl;
import org.springframework.stereotype.Component;

import javax.persistence.EntityManagerFactory;

/**
 * session池
 *
 * @author LocalUser
 */
@Component
public class SessionPool {
    private final EntityManagerFactory entityManagerFactory;

    private SessionPool(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    /**
     * 从sessionFactory中取
     *
     * @return session
     */
    public Session getSession() {
        SessionFactory factory = entityManagerFactory.unwrap(SessionFactoryImpl.class);
        return factory.getCurrentSession();
    }

    public SessionFactoryImpl getSessionFactory() {
        return entityManagerFactory.unwrap(SessionFactoryImpl.class);
    }
}
