package com.af.v4.system.restful.service;

import com.af.v4.system.api.RemoteEntityService;
import com.af.v4.system.common.core.constant.SecurityConstants;
import com.af.v4.system.common.core.domain.R;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 远程调用实体服务
 *
 * @author Mr.river
 */
@Service
public class LocalEntityService {
    private final RemoteEntityService entityService;

    private final Logger LOGGER = LoggerFactory.getLogger(LocalEntityService.class);

    public LocalEntityService(RemoteEntityService entityService) {
        this.entityService = entityService;
    }

    //    @GlobalTransactional
    public JSONObject partialSave(String entityName, JSONObject entity) {
        R<Map<String, Object>> entityResult = entityService.save(entityName, entity.toString(), SecurityConstants.INNER);
        return entityResult.parseResponseJson();
    }
}
