package com.af.v4.system.restful.logic;

import com.af.v4.system.expression.Delegate;
import com.af.v4.system.expression.Program;

import java.util.Map;

/**
 * 表达式执行入口
 *
 * @author LocalUser
 */
public class ExpressionHelper {

    /**
     * 带参运行表达式
     *
     * @param source: 表达式源码
     * @param params: 表达式参数
     */
    public static Object run(String source, Map<String, Object> params) {
        Delegate delegate = getDelegate(source);
        return delegate.invoke(params);
    }

    public static Delegate getDelegate(String source) {
        // 解析
        return new Program(source).parse();
    }
}
