package com.af.v4.system.plugins.http;

import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.json.JSONObject;

/**
 * HTTP异步请求工具类
 *
 * @author Mr.river
 */
public class RestAsyncTools {

    /**
     * 发送通用异步Http请求
     *
     * @param path           请求路径
     * @param value          请求参数
     * @param headers        请求头
     * @param base           请求类型
     * @param futureCallback 异步回调处理函数
     */
    public static void request(String path, String value, String headers, HttpClientConfig config, HttpRequestBase base, FutureCallback<HttpResponse> futureCallback) {
        JSONObject headerJson = BaseHttpPoolUtil.buildHeader(headers);
        HttpAsyncConnectionPoolUtil.request(path, value, headerJson.toString(), config, base, null, futureCallback);
    }

    public static void request(String path, String value, String headers, HttpClientConfig config, HttpRequestBase base) {
        JSONObject headerJson = BaseHttpPoolUtil.buildHeader(headers);
        HttpAsyncConnectionPoolUtil.request(path, value, headerJson.toString(), config, base);
    }


    public static void request(String path, String value, String headers, HttpRequestBase base) {
        request(path, value, headers, null, base);
    }

    /**
     * 发送post请求
     *
     * @param path    请求路径
     * @param value   请求体
     * @param headers 请求头
     */
    public static void post(String path, String value, String headers) {
        request(path, value, headers, new HttpPost());
    }

    public static void post(String path, JSONObject value, JSONObject headers) {
        if (value == null) {
            post(path, null, headers.toString());
        } else {
            post(path, value.toString(), headers.toString());
        }
    }

    public static void post(String path, JSONObject value) {
        post(path, value.toString(), null);
    }

    public static void post(String path, String value) {
        post(path, value, null);
    }

    public static void post(String path) {
        post(path, "", null);
    }

    /**
     * 发送get请求
     *
     * @param path    请求路径
     * @param headers 请求头
     */
    public static void get(String path, String headers) {
        request(path, null, headers, new HttpGet());
    }

    public static void get(String path, JSONObject headers) {
        get(path, headers.toString());
    }

    public static void get(String path) {
        get(path, "");
    }

    /**
     * 发送put请求
     *
     * @param path    请求路径
     * @param value   请求参数
     * @param headers 请求头
     */
    public static void put(String path, String value, String headers) {
        request(path, value, headers, new HttpPut());
    }

    public static void put(String path, JSONObject value, JSONObject headers) {
        if (value == null) {
            put(path, null, headers.toString());
        } else {
            put(path, value.toString(), headers.toString());
        }
    }

    public static void put(String path, String value) {
        put(path, value, "");
    }

    public static void put(String path, JSONObject value) {
        put(path, value.toString(), "");
    }

    public static void put(String path) {
        put(path, "", null);
    }

    /**
     * 发送delete请求
     *
     * @param path    请求路径
     * @param value   请求参数
     * @param headers 请求头
     * @return String结果
     */
    public static void delete(String path, String value, String headers) {
        request(path, value, headers, new HttpDeleteWithBody());
    }

    public static void delete(String path, JSONObject value, JSONObject headers) {
        if (value == null) {
            delete(path, null, headers.toString());
        } else {
            delete(path, value.toString(), headers.toString());
        }
    }

    public static void delete(String path, String value) {
        delete(path, value, "");
    }

    public static void delete(String path, JSONObject value) {
        delete(path, value.toString(), "");
    }

    public static void delete(String path) {
        delete(path, "", null);
    }
}
