package com.af.v4.system.plugins.http;

import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;

import java.net.URI;

/**
 * 自实现HttpDeleteWithBody
 * HttpClient自带delete请求无法使用body传递参数，
 * 如delete请求有body请求参数请使用该类
 *
 * @author Mr.river
 */
public class HttpDeleteWithBody extends HttpEntityEnclosingRequestBase {

    public static final String METHOD_NAME = "DELETE";

    public HttpDeleteWithBody(final String uri) {
        super();
        setURI(URI.create(uri));
    }

    public HttpDeleteWithBody() {
        super();
    }

    @Override
    public String getMethod() {
        return METHOD_NAME;
    }
}
