package com.af.v4.system.plugins.core;

import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Iterator;

/**
 * 金额格式化工具类
 *
 * @author Mr.river
 */
public class PriceFormatTools {
    static final NumberFormat NF;

    static {
        NF = NumberFormat.getInstance();
        NF.setGroupingUsed(false);
        NF.setMinimumFractionDigits(2);
        NF.setMaximumFractionDigits(4);
    }

    public static void formatNumber(JSONObject object) {
        Iterator<String> iterator = object.keys();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object value = object.get(key);
            if (value instanceof BigDecimal) {
                object.put(key, formatNumberBase(value));
            } else if (value instanceof JSONObject) {
                formatNumber((JSONObject) value);
            } else if (value instanceof JSONArray) {
                formatNumber((JSONArray) value);
            }
        }
    }

    public static void formatNumber(JSONArray object) {
        Iterator<Object> iterator = object.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            Object value = iterator.next();
            if (value instanceof BigDecimal) {
                object.put(index, formatNumberBase(value));
            } else if (value instanceof JSONObject) {
                formatNumber((JSONObject) value);
            } else if (value instanceof JSONArray) {
                formatNumber((JSONArray) value);
            }
            index++;
        }
    }

    public static String formatNumberBase(Object value) {
        return NF.format(value);
    }
}
