package com.af.v4.system.plugins.calculate;

import com.af.v4.system.plugins.core.PriceFormatTools;
import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * 固定价格计算工具类
 *
 * @author Mr.river
 */
public class UnitPriceSettlement implements ISettlementInterface {

    @Override
    public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas) {
        // 单价
        BigDecimal unitPrice = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_unitPrice")));
        // 费用 = 单价 * 气量
        BigDecimal fee = unitPrice.multiply(gas);

        return pack(fee, unitPrice, gas);
    }

    @Override
    public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
        // 单价
        BigDecimal unitPrice = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(0).get("f_unitPrice")));
        // 用气量 = 费用 / 单价
        BigDecimal gas = fee.divide(unitPrice, 2, RoundingMode.DOWN);

        return pack(fee, unitPrice, gas);
    }

    private JSONObject pack(BigDecimal fee, BigDecimal unitPrice, BigDecimal gas) {
        JSONArray array = new JSONArray();
        JSONObject json = new JSONObject();
        json.put("f_price_name", "固定气价");
        json.put("f_price", unitPrice);
        json.put("f_gas", gas);
        json.put("f_money", fee);
        array.put(json);

        JSONObject ret = new JSONObject();
        ret.put("chargeprice", array);
        ret.put("chargeNum", fee);
        ret.put("gas", gas);
        ret.put("money", fee);
        //格式化数字类型
        PriceFormatTools.formatNumber(ret);
        return ret;
    }
}
