package com.af.v4.system.plugins.calculate;

import com.af.v4.system.plugins.core.PriceFormatTools;
import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * 阶梯价格计算工具类
 *
 * @author Mr.river
 */
public class StairPriceSettlement implements ISettlementInterface {
    @Override
    public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas) {
        int length = chargeInfo.length();

        BigDecimal sumAmount = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(length - 1)
                .get("sumamount")));

        BigDecimal allAmount = sumAmount.add(gas);

        BigDecimal[] stairPrice = new BigDecimal[length - 1];
        BigDecimal[] stairAmount = new BigDecimal[length - 2];
        BigDecimal[] stairFee = new BigDecimal[length - 1];
        BigDecimal[] stairNum = new BigDecimal[length - 1];
        BigDecimal[] stairSurplus = new BigDecimal[length - 2];

        for (int i = 0; i < length - 1; i++) {
            stairPrice[i] = new BigDecimal("0");
            stairFee[i] = new BigDecimal("0");
            stairNum[i] = new BigDecimal("0");
        }

        for (int i = 0; i < length - 2; i++) {
            stairAmount[i] = new BigDecimal("0");
            stairSurplus[i] = new BigDecimal("0");
        }

        int start = 0;
        int end = 0;
        int i = 0;
        for (; i < length - 2; i++) {
            stairPrice[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("price")));
            stairAmount[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("amount")));

            if (allAmount.compareTo(sumAmount) > 0) {
                if (sumAmount.compareTo(stairAmount[i]) >= 0) {
                    start = i + 1;
                }

                if (allAmount.compareTo(stairAmount[i]) > 0) {
                    end = i + 1;
                }
            } else {
                if (allAmount.compareTo(stairAmount[i]) >= 0) {
                    start = i + 1;
                }

                if (sumAmount.compareTo(stairAmount[i]) >= 0) {
                    end = i + 1;
                }
            }

        }

        stairPrice[i] = new BigDecimal(String.valueOf(
                chargeInfo.getJSONObject(i).get("price")));

        BigDecimal multiply = stairNum[start].multiply(stairPrice[start]);
        BigDecimal decimal = stairNum[end].multiply(stairPrice[end])
                .setScale(4, RoundingMode.HALF_UP);
        if (gas.compareTo(BigDecimal.ZERO) > 0) {
            if (start == end) {
                stairNum[start] = gas;
                stairFee[start] = gas.multiply(stairPrice[start]).setScale(4, RoundingMode.HALF_UP);
            } else {
                stairNum[start] = stairAmount[start].subtract(sumAmount);
                stairFee[start] = multiply
                        .setScale(4, RoundingMode.HALF_UP);

                for (i = start + 1; i < end; i++) {
                    stairNum[i] = stairAmount[i].subtract(stairAmount[(i - 1)]);
                    stairFee[i] = stairNum[i].multiply(stairPrice[i]).setScale(
                            4, RoundingMode.HALF_UP);
                }
                stairNum[end] = allAmount.subtract(stairAmount[(end - 1)]);
                stairFee[end] = decimal;
            }
        } else {
            if (start == end) {
                stairNum[start] = gas;
                stairFee[start] = gas.multiply(stairPrice[start]);
            } else {
                stairNum[start] = allAmount.subtract(stairAmount[start]);
                stairFee[start] = multiply
                        .setScale(4, RoundingMode.HALF_UP);

                for (i = start + 1; i < end; i++) {
                    stairNum[i] = stairAmount[i - 1].subtract(stairAmount[i]);
                    stairFee[i] = stairNum[i].multiply(stairPrice[i]).setScale(
                            4, RoundingMode.HALF_UP);
                }

                stairNum[end] = stairAmount[(end - 1)].subtract(sumAmount);
                stairFee[end] = decimal;
            }
        }

        JSONObject ret = new JSONObject();
        BigDecimal chargeNum = new BigDecimal("0");
        BigDecimal oughtAmount = new BigDecimal("0");

        JSONArray array = new JSONArray();
        for (i = 0; i < length - 1; i++) {
            chargeNum = chargeNum.add(stairFee[i]);
            oughtAmount = oughtAmount.add(stairNum[i]);
            ret.put("f_stair" + (i + 1) + "fee", stairFee[i]);
            ret.put("f_stair" + (i + 1) + "amount", stairNum[i]);
            ret.put("f_stair" + (i + 1) + "price", stairPrice[i]);

            JSONObject json = new JSONObject();
            json.put("f_price_name", "阶梯" + (i + 1));
            json.put("f_price", stairPrice[i]);
            json.put("f_gas", stairNum[i]);
            json.put("f_money", stairFee[i]);
            array.put(json);
        }

        for (i = 0; i < stairAmount.length; i++) {
            ret.put("f_stair" + (i + 1) + "ceiling", stairAmount[i]);
        }

        for (i = 0; i < length - 2; i++) {
            if (allAmount.compareTo(stairAmount[i]) < 0) {
                for (int j = 0; j < i; j++) {
                    stairSurplus[j] = BigDecimal.ZERO;
                    ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
                }

                stairSurplus[i] = stairAmount[i].subtract(allAmount);
                ret.put("f_stair" + (i + 1) + "surplus", stairSurplus[i]);
                for (int j = i + 1; j < length - 2; j++) {
                    stairSurplus[j] = stairAmount[j]
                            .subtract(stairAmount[(j - 1)]);

                    ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
                }

                break;
            }
        }
        ret.put("chargenum", chargeNum);
        ret.put("oughtamount", oughtAmount);
        ret.put("sumamount", sumAmount);
        ret.put("chargeprice", array);
        //格式化数字类型
        PriceFormatTools.formatNumber(ret);
        return ret;
    }

    @Override
    public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
        int length = chargeInfo.length();

        BigDecimal sumAmount = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(length - 1)
                .get("sumamount")));
        BigDecimal sumAmount1 = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(length - 1)
                .get("sumamount")));

        BigDecimal[] stairPrice = new BigDecimal[length - 1];
        BigDecimal[] stairAmount = new BigDecimal[length - 2];
        BigDecimal[] stairFee = new BigDecimal[length - 1];
        BigDecimal[] stairNum = new BigDecimal[length - 1];
        BigDecimal[] stairSurplus = new BigDecimal[length - 2];

        JSONObject ret = new JSONObject();
        BigDecimal chargeNum = new BigDecimal("0");
        BigDecimal oughtAmount = new BigDecimal("0");

        for (int i = 0; i < length - 1; i++) {
            stairPrice[i] = new BigDecimal("0");
            stairFee[i] = new BigDecimal("0");
            stairNum[i] = new BigDecimal("0");
        }

        for (int i = 0; i < length - 2; i++) {
            stairAmount[i] = new BigDecimal("0");
            stairSurplus[i] = new BigDecimal("0");
        }

        int start = 0;
        int i = 0;
        for (; i < length - 2; i++) {
            stairPrice[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("price")));
            stairAmount[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("amount")));

            if (sumAmount.compareTo(stairAmount[i]) >= 0) {
                start = i + 1;
            }
        }

        stairPrice[i] = new BigDecimal(String.valueOf(chargeInfo.getJSONObject(i).get("price")));

        for (i = start; i < stairAmount.length; i++) {
            BigDecimal decimal = stairNum[i].multiply(stairPrice[i])
                    .setScale(4, RoundingMode.HALF_UP);
            if (stairAmount[i].subtract(sumAmount).multiply(stairPrice[i])
                    .compareTo(fee) >= 0) {
                stairNum[i] = fee.divide(stairPrice[i], 2, RoundingMode.HALF_UP);

                stairFee[i] = decimal;

                for (int j = 0; j < i; j++) {
                    stairSurplus[j] = BigDecimal.ZERO;
                    ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
                }

                stairSurplus[i] = stairAmount[i].subtract(stairNum[i])
                        .subtract(sumAmount);

                ret.put("f_stair" + (i + 1) + "surplus", stairSurplus[i]);

                for (int j = i + 1; j < stairAmount.length; j++) {
                    stairSurplus[j] = stairAmount[j]
                            .subtract(stairAmount[(j - 1)]);

                    ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
                }

                break;
            }
            stairNum[i] = stairAmount[i].subtract(sumAmount);
            stairFee[i] = decimal;

            fee = fee.subtract(stairFee[i]);
            sumAmount = stairAmount[i];
        }

        stairNum[i] = fee.divide(stairPrice[i], 2, RoundingMode.HALF_UP);
        stairFee[i] = fee;

        JSONArray array = new JSONArray();
        for (i = 0; i < length - 1; i++) {
            chargeNum = chargeNum.add(stairFee[i]);
            oughtAmount = oughtAmount.add(stairNum[i]);
            ret.put("f_stair" + (i + 1) + "fee", stairFee[i]);
            ret.put("f_stair" + (i + 1) + "amount", stairNum[i]);
            ret.put("f_stair" + (i + 1) + "price", stairPrice[i]);

            JSONObject json = new JSONObject();
            json.put("f_price_name", "阶梯" + (i + 1));
            json.put("f_price", stairPrice[i]);
            json.put("f_gas", stairNum[i]);
            json.put("f_money", stairFee[i]);
            array.put(json);
        }

        for (i = 0; i < stairAmount.length; i++) {
            ret.put("f_stair" + (i + 1) + "ceiling", stairAmount[i]);
        }
        int j;
        try {
            ret.get("f_stair1surplus");
        } catch (Exception ignored) {
        }
        for (j = 0; j < stairSurplus.length; j++) {
            //stairSurplus[j] = BigDecimal.ZERO;
            ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
            //system.out.println("阶梯" + (j + 1) + "剩余购气量 :" + stairSurplus[j]);
        }

        ret.put("chargenum", chargeNum);
        ret.put("sumamount", sumAmount1);
        ret.put("gas", oughtAmount);
        ret.put("chargeprice", array);
        //格式化数字类型
        PriceFormatTools.formatNumber(ret);
        return ret;
    }
}
